/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.EncodingDecodingBindAdviceHandler;
import org.springframework.cloud.stream.binder.kafka.streams.KafkaStreamsBindingInformationCatalogue;
import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.util.Assert;

public class KTableBoundElementFactory
extends AbstractBindingTargetFactory<KTable> {
    private final BindingServiceProperties bindingServiceProperties;
    private final EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler;
    private final KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue;

    KTableBoundElementFactory(BindingServiceProperties bindingServiceProperties, EncodingDecodingBindAdviceHandler encodingDecodingBindAdviceHandler, KafkaStreamsBindingInformationCatalogue kafkaStreamsBindingInformationCatalogue) {
        super(KTable.class);
        this.bindingServiceProperties = bindingServiceProperties;
        this.encodingDecodingBindAdviceHandler = encodingDecodingBindAdviceHandler;
        this.kafkaStreamsBindingInformationCatalogue = kafkaStreamsBindingInformationCatalogue;
    }

    public KTable createInput(String name) {
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(name);
        ConsumerProperties consumerProperties = bindingProperties.getConsumer();
        if (consumerProperties == null) {
            consumerProperties = this.bindingServiceProperties.getConsumerProperties(name);
            consumerProperties.setUseNativeDecoding(true);
        } else if (!this.encodingDecodingBindAdviceHandler.isDecodingSettingProvided()) {
            consumerProperties.setUseNativeDecoding(true);
        }
        consumerProperties.setMultiplex(true);
        KTableWrapperHandler wrapper = new KTableWrapperHandler();
        ProxyFactory proxyFactory = new ProxyFactory(new Class[]{KTableWrapper.class, KTable.class});
        proxyFactory.addAdvice((Advice)wrapper);
        KTable proxy = (KTable)proxyFactory.getProxy();
        this.kafkaStreamsBindingInformationCatalogue.addBindingNamePerTarget(proxy, name);
        return proxy;
    }

    public KTable createOutput(String name) {
        throw new UnsupportedOperationException("Outbound operations are not allowed on target type KTable");
    }

    private static class KTableWrapperHandler
    implements KTableWrapper,
    MethodInterceptor {
        private KTable<Object, Object> delegate;

        private KTableWrapperHandler() {
        }

        @Override
        public void wrap(KTable<Object, Object> delegate) {
            Assert.notNull(delegate, (String)"delegate cannot be null");
            if (this.delegate == null) {
                this.delegate = delegate;
            }
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            if (methodInvocation.getMethod().getDeclaringClass().equals(KTable.class)) {
                Assert.notNull(this.delegate, (String)("Trying to prepareConsumerBinding " + String.valueOf(methodInvocation.getMethod()) + "  but no delegate has been set."));
                return methodInvocation.getMethod().invoke(this.delegate, methodInvocation.getArguments());
            }
            if (methodInvocation.getMethod().getDeclaringClass().equals(KTableWrapper.class)) {
                return methodInvocation.getMethod().invoke((Object)this, methodInvocation.getArguments());
            }
            throw new IllegalStateException("Only KTable method invocations are permitted");
        }
    }

    public static interface KTableWrapper {
        public void wrap(KTable<Object, Object> var1);
    }
}

