/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.cassandra;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.cassandra.CassandraSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.cassandra.CassandraSpanSupplier;
import org.springframework.cloud.sleuth.instrument.cassandra.SleuthCassandraSpan;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

final class TraceStatement
implements MethodInterceptor {
    private final Span span;
    private Statement<?> delegate;

    private TraceStatement(Span span, Statement<?> delegate) {
        this.span = span;
        this.delegate = delegate;
    }

    public static <T> T createProxy(Span span, T target) {
        ProxyFactory factory = new ProxyFactory(ClassUtils.getAllInterfaces(target));
        factory.addInterface(CassandraSpanCustomizer.class);
        factory.addInterface(CassandraSpanSupplier.class);
        factory.setTarget(target);
        factory.addAdvice((Advice)new TraceStatement(span, (Statement)target));
        return (T)factory.getProxy();
    }

    public static boolean isTraceStatement(Statement<?> statement) {
        return statement instanceof CassandraSpanCustomizer && statement instanceof CassandraSpanSupplier;
    }

    public Span getSpan() {
        return this.span;
    }

    public String getSpanName(String defaultName) {
        String query = this.getCql();
        if (query.indexOf(32) > -1) {
            return query.substring(0, query.indexOf(32));
        }
        return defaultName;
    }

    private String getCql() {
        String query = "";
        if (this.delegate instanceof SimpleStatement) {
            query = TraceStatement.getQuery(this.delegate);
        } else if (this.delegate instanceof BoundStatement) {
            query = TraceStatement.getQuery(this.delegate);
        } else if (this.delegate instanceof BatchStatement) {
            StringJoiner joiner = new StringJoiner(";");
            for (BatchableStatement bs : (BatchStatement)this.delegate) {
                joiner.add(TraceStatement.getQuery(bs));
            }
            query = joiner.toString();
        }
        return query;
    }

    private static String getQuery(Statement<?> statement) {
        if (statement instanceof SimpleStatement) {
            return ((SimpleStatement)statement).getQuery();
        }
        if (statement instanceof BoundStatement) {
            return ((BoundStatement)statement).getPreparedStatement().getQuery();
        }
        return "";
    }

    @Nullable
    public Object invoke(@Nonnull MethodInvocation invocation) throws Throwable {
        if (invocation.getMethod().getName().equals("getSpan")) {
            return this.span;
        }
        if (invocation.getMethod().getName().equals("customizeSpan")) {
            AssertingSpan.of((DocumentedSpan)SleuthCassandraSpan.CASSANDRA_SPAN, (Span)this.span).name(this.getSpanName((String)invocation.getArguments()[0])).tag((TagKey)SleuthCassandraSpan.Tags.CQL_TAG, this.getCql());
            return null;
        }
        Object result = invocation.proceed();
        if (result instanceof Statement) {
            this.delegate = (Statement)result;
        }
        return result;
    }
}

