/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web.reactive;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.servicebroker.autoconfigure.web.ServiceBrokerProperties;
import org.springframework.cloud.servicebroker.autoconfigure.web.reactive.ApiVersionWebFilter;
import org.springframework.cloud.servicebroker.model.BrokerApiVersion;
import org.springframework.cloud.servicebroker.service.ServiceInstanceService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnBean(value={ServiceInstanceService.class})
@ConditionalOnProperty(prefix="spring.cloud.openservicebroker", name={"api-version-check-enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={WebFluxAutoConfiguration.class})
@EnableConfigurationProperties(value={ServiceBrokerProperties.class})
public class ApiVersionWebFluxAutoConfiguration {
    private final ServiceBrokerProperties serviceBrokerProperties;

    public ApiVersionWebFluxAutoConfiguration(ServiceBrokerProperties serviceBrokerProperties) {
        this.serviceBrokerProperties = serviceBrokerProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={BrokerApiVersion.class})
    @ConditionalOnProperty(prefix="spring.cloud.openservicebroker", name={"api-version"})
    public BrokerApiVersion serviceBrokerApiVersionProperty() {
        return new BrokerApiVersion(this.serviceBrokerProperties.getApiVersion());
    }

    @Bean
    @ConditionalOnMissingBean(value={BrokerApiVersion.class})
    public BrokerApiVersion serviceBrokerApiVersion() {
        return new BrokerApiVersion();
    }

    @Bean
    public ApiVersionWebFilter apiVersionWebFilter(BrokerApiVersion brokerApiVersion) {
        return new ApiVersionWebFilter(brokerApiVersion);
    }
}

