/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.KubernetesAutoConfiguration;
import org.springframework.cloud.kubernetes.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.config.SecretsPropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={ConfigMap.class, Secret.class})
public class BootstrapConfiguration {

    @Configuration
    @Import(value={KubernetesAutoConfiguration.class})
    @EnableConfigurationProperties(value={ConfigMapConfigProperties.class, SecretsConfigProperties.class})
    protected static class KubernetesPropertySourceConfiguration {
        @Autowired
        private KubernetesClient client;

        protected KubernetesPropertySourceConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"spring.cloud.kubernetes.config.enabled"}, matchIfMissing=true)
        public ConfigMapPropertySourceLocator configMapPropertySourceLocator(ConfigMapConfigProperties properties) {
            return new ConfigMapPropertySourceLocator(this.client, properties);
        }

        @Bean
        @ConditionalOnProperty(name={"spring.cloud.kubernetes.secrets.enabled"}, matchIfMissing=true)
        public SecretsPropertySourceLocator secretsPropertySourceLocator(SecretsConfigProperties properties) {
            return new SecretsPropertySourceLocator(this.client, properties);
        }
    }
}

