/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.config.RouteProperties;
import org.springframework.cloud.gateway.server.mvc.handler.HandlerFunctionDefinition;
import org.springframework.cloud.gateway.server.mvc.handler.HandlerFunctions;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.ServerResponse;

@AutoConfiguration
public class HandlerFunctionAutoConfiguration {
    @Bean
    public Function<RouteProperties, HandlerFunctionDefinition> fnHandlerFunctionDefinition() {
        return routeProperties -> new HandlerFunctionDefinition.Default("fn", HandlerFunctions.fn(routeProperties.getUri().getSchemeSpecificPart()));
    }

    @Bean
    public Function<RouteProperties, HandlerFunctionDefinition> forwardHandlerFunctionDefinition() {
        return routeProperties -> new HandlerFunctionDefinition.Default("forward", HandlerFunctions.forward(routeProperties.getUri().getPath()));
    }

    @Bean
    public Function<RouteProperties, HandlerFunctionDefinition> httpHandlerFunctionDefinition() {
        return routeProperties -> HandlerFunctionAutoConfiguration.getResult("http", routeProperties.getId(), routeProperties.getUri(), HandlerFunctions.http());
    }

    @Bean
    public Function<RouteProperties, HandlerFunctionDefinition> httpsHandlerFunctionDefinition() {
        return routeProperties -> HandlerFunctionAutoConfiguration.getResult("https", routeProperties.getId(), routeProperties.getUri(), HandlerFunctions.https());
    }

    @Bean
    public Function<RouteProperties, HandlerFunctionDefinition> noHandlerFunctionDefinition() {
        return routeProperties -> HandlerFunctionAutoConfiguration.getResult("no", routeProperties.getId(), routeProperties.getUri(), HandlerFunctions.no());
    }

    @Bean
    public Function<RouteProperties, HandlerFunctionDefinition> streamHandlerFunctionDefinition() {
        return routeProperties -> new HandlerFunctionDefinition.Default("stream", HandlerFunctions.stream(routeProperties.getUri().getSchemeSpecificPart()));
    }

    private static HandlerFunctionDefinition getResult(String scheme, String id, URI uri, HandlerFunction<ServerResponse> handlerFunction) {
        HandlerFilterFunction<ServerResponse, ServerResponse> setId = HandlerFunctionAutoConfiguration.setIdFilter(id);
        HandlerFilterFunction<ServerResponse, ServerResponse> setRequest = HandlerFunctionAutoConfiguration.setRequestUrlFilter(uri);
        return new HandlerFunctionDefinition.Default(scheme, handlerFunction, Arrays.asList(setId, setRequest), Collections.emptyList());
    }

    private static HandlerFilterFunction<ServerResponse, ServerResponse> setIdFilter(String id) {
        return (request, next) -> {
            MvcUtils.setRouteId(request, id);
            return next.handle(request);
        };
    }

    private static HandlerFilterFunction<ServerResponse, ServerResponse> setRequestUrlFilter(URI uri) {
        return (request, next) -> {
            MvcUtils.setRequestUrl(request, uri);
            return next.handle(request);
        };
    }
}

