/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractNameValueGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class AddRequestParameterGatewayFilterFactory
extends AbstractNameValueGatewayFilterFactory {
    @Override
    public GatewayFilter apply(final AbstractNameValueGatewayFilterFactory.NameValueConfig config) {
        return new GatewayFilter(){
            final /* synthetic */ AddRequestParameterGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                URI uri = exchange.getRequest().getURI();
                StringBuilder query = new StringBuilder();
                String originalQuery = uri.getRawQuery();
                if (StringUtils.hasText((String)originalQuery)) {
                    query.append(originalQuery);
                    if (originalQuery.charAt(originalQuery.length() - 1) != '&') {
                        query.append('&');
                    }
                }
                String value = ServerWebExchangeUtils.expand(exchange, config.getValue());
                query.append(config.getName());
                query.append('=');
                query.append(value);
                boolean encoded = ServerWebExchangeUtils.containsEncodedParts(uri);
                try {
                    URI newUri = UriComponentsBuilder.fromUri((URI)uri).replaceQuery(query.toString()).build(encoded).toUri();
                    ServerHttpRequest request = exchange.getRequest().mutate().uri(newUri).build();
                    return chain.filter(exchange.mutate().request(request).build());
                }
                catch (RuntimeException ex) {
                    throw new IllegalStateException("Invalid URI query: \"" + query.toString() + "\"");
                }
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append(config.getName(), (Object)config.getValue()).toString();
            }
        };
    }
}

