/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.dsl.wiremock;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.converter.YamlContractConverter;
import org.springframework.cloud.contract.verifier.dsl.wiremock.GraphQlMatcher;
import org.springframework.cloud.contract.verifier.dsl.wiremock.RequestMatcher;
import org.springframework.cloud.contract.verifier.dsl.wiremock.RequestMatcherFactory;

public class SpringCloudContractRequestMatcher
extends RequestMatcherExtension {
    private static final List<String> SUPPORTED_TOOLS = Arrays.asList("graphql");
    public static final String NAME = "spring-cloud-contract";
    private static final Log log = LogFactory.getLog(SpringCloudContractRequestMatcher.class);

    public MatchResult match(Request request, Parameters parameters) {
        Object contracts;
        if (!parameters.containsKey((Object)"contract") || !parameters.containsKey((Object)"tool")) {
            return MatchResult.noMatch((SubEvent[])new SubEvent[0]);
        }
        String tool = parameters.getString("tool");
        if (!SUPPORTED_TOOLS.contains(tool)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("The tool [" + tool + "] is not supported"));
            }
            return MatchResult.noMatch((SubEvent[])new SubEvent[0]);
        }
        String string = parameters.getString("contract");
        try {
            contracts = YamlContractConverter.INSTANCE.read(string.getBytes());
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"An exception occurred while trying to parse the contract", (Throwable)e);
            }
            return MatchResult.noMatch((SubEvent[])new SubEvent[0]);
        }
        return new RequestMatcherFactory(this.matchers()).pick(tool).match((List<YamlContract>)contracts, request, parameters);
    }

    List<RequestMatcher> matchers() {
        return Arrays.asList(new GraphQlMatcher());
    }

    public String getName() {
        return NAME;
    }
}

