/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.template.TemplateProcessor;

interface GroovyBodyParser
extends BodyParser {
    @Override
    default public String convertUnicodeEscapesIfRequired(String json) {
        return StringEscapeUtils.unescapeEcmaScript((String)json);
    }

    @Override
    default public String postProcessJsonPath(String jsonPath) {
        if (this.templateProcessor().containsTemplateEntry(jsonPath)) {
            return jsonPath;
        }
        return jsonPath.replace("$", "\\$");
    }

    public TemplateProcessor templateProcessor();

    @Override
    default public String escape(String text) {
        return text.replaceAll("\\n", "\\\\n");
    }

    @Override
    default public String escapeForSimpleTextAssertion(String text) {
        return this.escape(text);
    }

    @Override
    default public String quotedShortText(Object text) {
        String string = text.toString();
        if (text instanceof Number) {
            return string;
        }
        if (string.contains("'") || string.contains("\"")) {
            return this.quotedLongText(text);
        }
        return "'" + this.groovyEscapedString(text.toString()) + "'";
    }

    @Override
    default public String quotedEscapedShortText(Object text) {
        String string = text.toString();
        if (text instanceof Number) {
            return string;
        }
        if (string.contains("'") || string.contains("\"")) {
            return this.quotedEscapedLongText(text);
        }
        return "'" + text.toString() + "'";
    }

    @Override
    default public String quotedEscapedLongText(Object text) {
        return "'''" + text.toString() + "'''";
    }

    @Override
    default public String quotedLongText(Object text) {
        Object escapedString = this.groovyEscapedString(text);
        if (((String)escapedString).startsWith("'")) {
            escapedString = "\\'" + ((String)escapedString).substring(1);
        }
        if (((String)escapedString).endsWith("'")) {
            escapedString = ((String)escapedString).substring(0, ((String)escapedString).length() - 1) + "\\'";
        }
        return "'''" + (String)escapedString + "'''";
    }

    default public String groovyEscapedString(Object text) {
        return this.escape(text.toString()).replaceAll("\\\\\"", "\"");
    }
}

