/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder.handlebars;

import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.WireMockHelpers;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.Map;
import org.springframework.cloud.contract.verifier.builder.TestSideRequestTemplateModel;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;

public class HandlebarsJsonPathHelper
implements Helper<Object> {
    public static final String NAME = "jsonpath";
    public static final String REQUEST_MODEL_NAME = "request";

    public Object apply(Object context, Options options) throws IOException {
        if (context instanceof Map) {
            Map oldContext = (Map)context;
            String jsonPath = (String)options.param(0);
            Object model = oldContext.get(REQUEST_MODEL_NAME);
            if (model instanceof TestSideRequestTemplateModel) {
                return this.returnObjectForTest((TestSideRequestTemplateModel)model, jsonPath);
            }
            if (model instanceof RequestTemplateModel) {
                return this.returnObjectForStub(model, jsonPath);
            }
            throw new IllegalArgumentException("Unsupported model");
        }
        if (context instanceof String) {
            Object value = WireMockHelpers.jsonPath.apply(context, options);
            if (this.testSideModel(options)) {
                return this.processTestResponseValue(value);
            }
            return value;
        }
        throw new IllegalArgumentException("Unsupported context");
    }

    private boolean testSideModel(Options options) {
        Object model = options.context.model();
        if (!(model instanceof Map)) {
            return false;
        }
        Map map = (Map)model;
        return map.values().stream().anyMatch(o -> o instanceof TestSideRequestTemplateModel);
    }

    private Object returnObjectForStub(Object model, String jsonPath) {
        DocumentContext documentContext = JsonPath.parse((String)((RequestTemplateModel)model).getBody());
        return documentContext.read(jsonPath, new Predicate[0]);
    }

    private Object returnObjectForTest(TestSideRequestTemplateModel model, String jsonPath) {
        String body = this.removeSurroundingQuotes(model.getEscapedBody()).replace("\\\"", "\"");
        DocumentContext documentContext = JsonPath.parse((String)body);
        Object value = documentContext.read(jsonPath, new Predicate[0]);
        return this.processTestResponseValue(value);
    }

    private Object processTestResponseValue(Object value) {
        if (value instanceof Long) {
            return (Long)value + "L";
        }
        return value;
    }

    private String removeSurroundingQuotes(String body) {
        if (body.startsWith("\"") && body.endsWith("\"")) {
            return body.substring(1, body.length() - 1);
        }
        return body;
    }
}

