/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Imports;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class JsonPathImports
implements Imports {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private static final String[] IMPORTS = new String[]{"com.jayway.jsonpath.DocumentContext", "com.jayway.jsonpath.JsonPath"};

    JsonPathImports(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public Imports call() {
        Arrays.stream(IMPORTS).forEach(s -> this.blockBuilder.addLineWithEnding("import " + s));
        return this;
    }

    @Override
    public boolean accept() {
        return this.generatedClassMetaData.listOfFiles.stream().anyMatch(metadata -> metadata.getConvertedContractWithMetadata().stream().anyMatch(SingleContractMetadata::isJson));
    }
}

