/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.spec.internal.Url;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class CustomModeMethodWithUrlGiven
implements Given {
    private final BlockBuilder blockBuilder;
    private final BodyParser bodyParser;

    CustomModeMethodWithUrlGiven(BlockBuilder blockBuilder, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.bodyParser = bodyParser;
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata metadata) {
        this.addUrl(this.getUrl(metadata.getContract().getRequest()), metadata.getContract().getRequest());
        return this;
    }

    private Url getUrl(Request request) {
        if (request.getUrl() != null) {
            return request.getUrl();
        }
        if (request.getUrlPath() != null) {
            return request.getUrlPath();
        }
        throw new IllegalStateException("URL is not set!");
    }

    private void addUrl(Url buildUrl, Request request) {
        Object testSideUrl = MapConverter.getTestSideValues(buildUrl);
        String method = request.getMethod().getServerValue().toString().toLowerCase();
        String url = testSideUrl.toString();
        if (!(testSideUrl instanceof ExecutionProperty)) {
            url = this.bodyParser.quotedShortText(testSideUrl.toString());
        }
        this.blockBuilder.addIndented("." + method + "(" + url + ")");
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        return request != null;
    }
}

