/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.loadbalancer;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.util.StringUtils;

class StubbedServiceInstance
implements ServiceInstance {
    private final StubFinder stubFinder;
    private final StubMapperProperties stubMapperProperties;
    private final String serviceId;
    static final Map<String, Map.Entry<StubConfiguration, Integer>> CACHE = new ConcurrentHashMap<String, Map.Entry<StubConfiguration, Integer>>();

    StubbedServiceInstance(StubFinder stubFinder, StubMapperProperties stubMapperProperties, String serviceId) {
        this.stubFinder = stubFinder;
        this.stubMapperProperties = stubMapperProperties;
        this.serviceId = serviceId;
    }

    private Map.Entry<StubConfiguration, Integer> stubEntry() {
        Map.Entry<StubConfiguration, Integer> entry = CACHE.get(this.serviceId);
        if (entry != null) {
            return entry;
        }
        RunningStubs runningStubs = this.stubFinder.findAllRunningStubs();
        String mappedServiceName = StringUtils.hasText((String)this.stubMapperProperties.fromServiceIdToIvyNotation(this.serviceId)) ? this.stubMapperProperties.fromServiceIdToIvyNotation(this.serviceId) : this.serviceId;
        entry = runningStubs.getEntry(mappedServiceName);
        CACHE.put(this.serviceId, entry);
        return entry;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getHost() {
        return "localhost";
    }

    public int getPort() {
        Map.Entry<StubConfiguration, Integer> entry = this.stubEntry();
        if (entry == null) {
            return 0;
        }
        return entry.getValue();
    }

    public boolean isSecure() {
        return false;
    }

    public URI getUri() {
        return URI.create((this.isSecure() ? "https://" : "http://") + this.getHost() + ":" + this.getPort());
    }

    public Map<String, String> getMetadata() {
        return null;
    }
}

