/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier.stubrunner;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.aether.RepositorySystemSession;
import org.springframework.cloud.contract.maven.verifier.stubrunner.AetherStubDownloaderFactory;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;

@Named
public class RemoteStubRunner {
    private static final Log log = LogFactory.getLog(RemoteStubRunner.class);
    private final AetherStubDownloaderFactory aetherStubDownloaderFactory;

    @Inject
    public RemoteStubRunner(AetherStubDownloaderFactory aetherStubDownloaderFactory) {
        this.aetherStubDownloaderFactory = aetherStubDownloaderFactory;
    }

    public BatchStubRunner run(StubRunnerOptions options, RepositorySystemSession repositorySystemSession) {
        StubDownloader stubDownloader = this.aetherStubDownloaderFactory.build(repositorySystemSession).build(options);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Launching StubRunner with args: " + options));
            }
            BatchStubRunner stubRunner = new BatchStubRunnerFactory(options, stubDownloader).buildBatchStubRunner();
            RunningStubs runningCollaborators = stubRunner.runStubs();
            log.info((Object)runningCollaborators.toString());
            return stubRunner;
        }
        catch (Exception e) {
            log.error((Object)("An exception occurred while trying to execute the stubs: " + e.getMessage()));
            throw e;
        }
    }
}

