/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindHandlerAdvisor;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.util.CollectionUtils;

public class DefaultsBindHandlerAdvisor
implements ConfigurationPropertiesBindHandlerAdvisor {
    private final Map<ConfigurationPropertyName, ConfigurationPropertyName> mappings = new LinkedHashMap<ConfigurationPropertyName, ConfigurationPropertyName>();

    public DefaultsBindHandlerAdvisor(Map<ConfigurationPropertyName, ConfigurationPropertyName> additionalMappings) {
        if (!CollectionUtils.isEmpty(additionalMappings)) {
            this.mappings.putAll(additionalMappings);
        }
    }

    public BindHandler apply(final BindHandler bindHandler) {
        AbstractBindHandler handler = new AbstractBindHandler(this, bindHandler){
            final /* synthetic */ DefaultsBindHandlerAdvisor this$0;
            {
                this.this$0 = this$0;
                super(parent);
            }

            public <T> Bindable<T> onStart(ConfigurationPropertyName name, Bindable<T> target, BindContext context) {
                BindResult result;
                ConfigurationPropertyName defaultName = this.this$0.getDefaultName(name);
                if (defaultName != null && (result = context.getBinder().bind(defaultName, target)).isBound()) {
                    return target.withExistingValue(result.get());
                }
                return bindHandler.onStart(name, target, context);
            }
        };
        return handler;
    }

    private ConfigurationPropertyName getDefaultName(ConfigurationPropertyName name) {
        for (Map.Entry<ConfigurationPropertyName, ConfigurationPropertyName> mapping : this.mappings.entrySet()) {
            ConfigurationPropertyName from = mapping.getKey();
            ConfigurationPropertyName to = mapping.getValue();
            if (!from.isAncestorOf(name) || name.getNumberOfElements() <= from.getNumberOfElements()) continue;
            ConfigurationPropertyName defaultName = to;
            for (int i = from.getNumberOfElements() + 1; i < name.getNumberOfElements(); ++i) {
                defaultName = defaultName.append(name.getElement(i, ConfigurationPropertyName.Form.UNIFORM));
            }
            return defaultName;
        }
        return null;
    }

    public static interface MappingsProvider {
        public Map<ConfigurationPropertyName, ConfigurationPropertyName> getDefaultMappings();
    }
}

