/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.circuitbreaker.httpservice;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.httpservice.CircuitBreakerConfigurerUtils;
import org.springframework.cloud.client.circuitbreaker.httpservice.CircuitBreakerRequestValueProcessor;
import org.springframework.cloud.client.circuitbreaker.httpservice.ReactiveCircuitBreakerAdapterDecorator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientHttpServiceGroupConfigurer;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.ReactorHttpExchangeAdapter;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;

public class CircuitBreakerWebClientHttpServiceGroupConfigurer
implements WebClientHttpServiceGroupConfigurer,
ApplicationContextAware {
    private static final int ORDER = 16;
    private final ReactiveCircuitBreakerFactory<?, ?> reactiveCircuitBreakerFactory;
    private final CircuitBreakerFactory<?, ?> circuitBreakerFactory;
    private ApplicationContext applicationContext;

    public CircuitBreakerWebClientHttpServiceGroupConfigurer(ReactiveCircuitBreakerFactory<?, ?> reactiveCircuitBreakerFactory, CircuitBreakerFactory<?, ?> circuitBreakerFactory) {
        this.reactiveCircuitBreakerFactory = reactiveCircuitBreakerFactory;
        this.circuitBreakerFactory = circuitBreakerFactory;
    }

    public void configureGroups(HttpServiceGroupConfigurer.Groups<WebClient.Builder> groups) {
        groups.forEachGroup((group, clientBuilder, factoryBuilder) -> {
            String groupName = group.name();
            Map<String, Class<?>> perGroupFallbackClasses = CircuitBreakerConfigurerUtils.resolveAnnotatedFallbackClasses(this.applicationContext, groupName);
            Map<String, Class<?>> fallbackClasses = !perGroupFallbackClasses.isEmpty() ? perGroupFallbackClasses : CircuitBreakerConfigurerUtils.resolveAnnotatedFallbackClasses(this.applicationContext, null);
            factoryBuilder.httpRequestValuesProcessor((HttpRequestValues.Processor)new CircuitBreakerRequestValueProcessor());
            factoryBuilder.exchangeAdapterDecorator(httpExchangeAdapter -> {
                Assert.isInstanceOf(ReactorHttpExchangeAdapter.class, (Object)httpExchangeAdapter);
                return new ReactiveCircuitBreakerAdapterDecorator((ReactorHttpExchangeAdapter)httpExchangeAdapter, this.buildReactiveCircuitBreaker(groupName), this.buildCircuitBreaker(groupName), fallbackClasses);
            });
        });
    }

    private ReactiveCircuitBreaker buildReactiveCircuitBreaker(String groupName) {
        return this.reactiveCircuitBreakerFactory.create(groupName + "-reactive");
    }

    private CircuitBreaker buildCircuitBreaker(String groupName) {
        return this.circuitBreakerFactory.create(groupName);
    }

    public int getOrder() {
        return 16;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

