/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.circuitbreaker.httpservice;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cloud.client.circuitbreaker.NoFallbackAvailableException;
import org.springframework.cloud.client.circuitbreaker.httpservice.FallbackProxyCreationException;
import org.springframework.cloud.client.circuitbreaker.httpservice.HttpServiceFallback;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.StringUtils;
import org.springframework.web.service.invoker.HttpRequestValues;

final class CircuitBreakerConfigurerUtils {
    public static final String DEFAULT_FALLBACK_KEY = "default";
    private static final Log LOG = LogFactory.getLog(CircuitBreakerConfigurerUtils.class);

    private CircuitBreakerConfigurerUtils() {
        throw new UnsupportedOperationException("Cannot instantiate a utility class");
    }

    static Map<String, Class<?>> resolveFallbackClasses(Map<String, String> fallbackClassNames) {
        return fallbackClassNames.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> CircuitBreakerConfigurerUtils.resolveFallbackClass((String)entry.getValue())));
    }

    static <T> T castIfPossible(Object result) {
        try {
            return (T)result;
        }
        catch (ClassCastException exception) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Failed to cast object of type " + String.valueOf(result.getClass()) + " to expected type."));
            }
            throw exception;
        }
    }

    static Map<String, Class<?>> resolveAnnotatedFallbackClasses(ApplicationContext context, @Nullable String groupName) {
        Map fallbackConfigurationBeans = context.getBeansWithAnnotation(HttpServiceFallback.class);
        HashMap fallbackClasses = new HashMap();
        for (Object fallbackConfigurationBean : fallbackConfigurationBeans.values()) {
            MergedAnnotations annotations = MergedAnnotations.from(fallbackConfigurationBean.getClass(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
            for (MergedAnnotation annotation : annotations.stream(HttpServiceFallback.class).toList()) {
                String group = annotation.getString("group");
                if ((!StringUtils.hasText((String)groupName) || !groupName.equals(group)) && (StringUtils.hasText((String)groupName) || StringUtils.hasText((String)group))) continue;
                CircuitBreakerConfigurerUtils.addFallbackEntries(annotation.getClass("value"), annotation.getClassArray("service"), fallbackClasses);
            }
        }
        return fallbackClasses;
    }

    private static void addFallbackEntries(Class<?> fallbackBeanClass, Class<?>[] services, Map<String, Class<?>> fallbackClasses) {
        if (services.length == 0) {
            CircuitBreakerConfigurerUtils.addFallbackEntry(fallbackClasses, DEFAULT_FALLBACK_KEY, fallbackBeanClass);
        } else {
            for (Class<?> serviceClass : services) {
                CircuitBreakerConfigurerUtils.addFallbackEntry(fallbackClasses, serviceClass.getName(), fallbackBeanClass);
            }
        }
    }

    private static void addFallbackEntry(Map<String, Class<?>> map, String key, Class<?> fallbackClass) {
        if (map.containsKey(key)) {
            throw new IllegalStateException("Duplicate fallback key: " + key);
        }
        map.put(key, fallbackClass);
    }

    static Method resolveFallbackMethod(Map<String, Object> attributes, boolean withThrowable, Class<?> fallbackClass) {
        if (fallbackClass == null) {
            return null;
        }
        String methodName = String.valueOf(attributes.get("spring.cloud.method.name"));
        Class[] paramTypes = (Class[])attributes.get("spring.cloud.method.parameter-types");
        paramTypes = paramTypes != null ? paramTypes : new Class[]{};
        Class[] effectiveTypes = withThrowable ? (Class[])Stream.concat(Stream.of(Throwable.class), Arrays.stream(paramTypes)).toArray(Class[]::new) : paramTypes;
        try {
            Method method = fallbackClass.getMethod(methodName, effectiveTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException exception) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Fallback method not found: " + methodName + " in " + fallbackClass.getName()), (Throwable)exception);
            }
            return null;
        }
    }

    static Object invokeFallback(Method method, Map<String, Object> attributes, @Nullable Throwable throwable, Object fallbackProxy) {
        try {
            Object[] args = (Object[])attributes.get("spring.cloud.method.arguments");
            args = args != null ? args : new Class[]{};
            Object[] finalArgs = throwable != null ? Stream.concat(Stream.of(throwable), Arrays.stream(args)).toArray(Object[]::new) : args;
            return method.invoke(fallbackProxy, finalArgs);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            Throwable underlyingException;
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error invoking fallback method: " + method.getName()), (Throwable)exception);
            }
            if ((underlyingException = exception.getCause()) instanceof RuntimeException) {
                throw (RuntimeException)underlyingException;
            }
            if (underlyingException != null) {
                throw new IllegalStateException("Failed to invoke fallback method", underlyingException);
            }
            throw new RuntimeException("Failed to invoke fallback method", exception);
        }
    }

    static Object getFallback(HttpRequestValues requestValues, Throwable throwable, Map<String, Object> fallbackProxies, Map<String, Class<?>> fallbackClasses) {
        Map attributes = requestValues.getAttributes();
        String declaringClassName = (String)attributes.get("spring.cloud.method.declaring-class");
        Class<?> fallbackClass = fallbackClasses.getOrDefault(declaringClassName, fallbackClasses.get(DEFAULT_FALLBACK_KEY));
        Method fallback = CircuitBreakerConfigurerUtils.resolveFallbackMethod(attributes, false, fallbackClass);
        Method fallbackWithCause = CircuitBreakerConfigurerUtils.resolveFallbackMethod(attributes, true, fallbackClass);
        Object fallbackProxy = fallbackProxies.getOrDefault(declaringClassName, fallbackProxies.get(DEFAULT_FALLBACK_KEY));
        if (fallback != null) {
            return CircuitBreakerConfigurerUtils.invokeFallback(fallback, attributes, null, fallbackProxy);
        }
        if (fallbackWithCause != null) {
            return CircuitBreakerConfigurerUtils.invokeFallback(fallbackWithCause, attributes, throwable, fallbackProxy);
        }
        throw new NoFallbackAvailableException("No fallback available.", throwable);
    }

    static Map<String, Object> createProxies(Map<String, Class<?>> fallbackClasses) {
        return fallbackClasses.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> CircuitBreakerConfigurerUtils.createProxy((Class)entry.getValue())));
    }

    private static Class<?> resolveFallbackClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Fallback class not found: " + className), (Throwable)e);
            }
            throw new IllegalStateException("Unable to load fallback class: " + className, e);
        }
    }

    static Object createProxy(Class<?> fallbackClass) {
        try {
            Object target = fallbackClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ProxyFactory proxyFactory = new ProxyFactory(target);
            proxyFactory.setProxyTargetClass(true);
            return proxyFactory.getProxy();
        }
        catch (ReflectiveOperationException exception) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error instantiating fallback proxy for class: " + fallbackClass.getName() + ", exception: " + exception.getMessage()), (Throwable)exception);
            }
            throw new FallbackProxyCreationException("Could not create fallback proxy", exception);
        }
    }
}

