/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.circuitbreaker.httpservice;

import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.web.service.invoker.HttpRequestValues;

public class CircuitBreakerRequestValueProcessor
implements HttpRequestValues.Processor {
    public static final String METHOD_ATTRIBUTE_NAME = "spring.cloud.method.name";
    public static final String PARAMETER_TYPES_ATTRIBUTE_NAME = "spring.cloud.method.parameter-types";
    public static final String ARGUMENTS_ATTRIBUTE_NAME = "spring.cloud.method.arguments";
    public static final String RETURN_TYPE_ATTRIBUTE_NAME = "spring.cloud.method.return-type";
    public static final String DECLARING_CLASS_ATTRIBUTE_NAME = "spring.cloud.method.declaring-class";

    public void process(Method method, MethodParameter[] parameters, @Nullable Object[] arguments, HttpRequestValues.Builder builder) {
        builder.addAttribute(METHOD_ATTRIBUTE_NAME, (Object)method.getName());
        builder.addAttribute(PARAMETER_TYPES_ATTRIBUTE_NAME, method.getParameterTypes());
        builder.addAttribute(ARGUMENTS_ATTRIBUTE_NAME, (Object)arguments);
        builder.addAttribute(RETURN_TYPE_ATTRIBUTE_NAME, method.getReturnType());
        builder.addAttribute(DECLARING_CLASS_ATTRIBUTE_NAME, (Object)method.getDeclaringClass().getCanonicalName());
    }
}

