/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple.reactive;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.health.contributor.ReactiveHealthIndicator;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ReactiveCommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClientConfigurations;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnReactiveDiscoveryEnabled
@EnableConfigurationProperties(value={DiscoveryClientHealthIndicatorProperties.class})
@AutoConfigureBefore(value={ReactiveCommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={ReactiveCompositeDiscoveryClientAutoConfiguration.class})
@Import(value={SimpleReactiveDiscoveryClientConfigurations.StandardSimpleReactiveDiscoveryClientConfiguration.class, SimpleReactiveDiscoveryClientConfigurations.WebApplicationSimpleReactiveDiscoveryClientConfiguration.class})
public class SimpleReactiveDiscoveryClientAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ReactiveHealthIndicator.class})
    protected static class HealthConfiguration {
        protected HealthConfiguration() {
        }

        @Bean
        @ConditionalOnDiscoveryHealthIndicatorEnabled
        public ReactiveDiscoveryClientHealthIndicator simpleReactiveDiscoveryClientHealthIndicator(DiscoveryClientHealthIndicatorProperties properties, SimpleReactiveDiscoveryClient simpleReactiveDiscoveryClient) {
            return new ReactiveDiscoveryClientHealthIndicator(simpleReactiveDiscoveryClient, properties);
        }
    }
}

