/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.web.server.context.WebServerInitializedEvent;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

class SimpleDiscoveryClientConfigurations {
    SimpleDiscoveryClientConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebServerInitializedEvent.class})
    static class WebApplicationSimpleDiscoveryClientConfiguration
    extends SimpleDiscoveryClientConfiguration
    implements ApplicationListener<WebServerInitializedEvent> {
        private final ObjectProvider<ServerProperties> serverProperties;
        private int port;

        WebApplicationSimpleDiscoveryClientConfiguration(InetUtils inet, ObjectProvider<ServerProperties> serverProperties) {
            super(inet);
            this.serverProperties = serverProperties;
        }

        public void onApplicationEvent(WebServerInitializedEvent webServerInitializedEvent) {
            this.port = webServerInitializedEvent.getWebServer().getPort();
            if (this.port > 0) {
                this.simple.getLocal().setHost(this.inet.findFirstNonLoopbackHostInfo().getHostname());
                this.simple.getLocal().setPort(this.port);
            }
        }

        @Override
        protected int findPort() {
            if (this.port > 0) {
                return this.port;
            }
            ServerProperties server = (ServerProperties)this.serverProperties.getIfAvailable();
            if (server != null && server.getPort() != null && server.getPort() > 0) {
                return server.getPort();
            }
            return super.findPort();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.boot.web.server.context.WebServerInitializedEvent"})
    static class StandardSimpleDiscoveryClientConfiguration
    extends SimpleDiscoveryClientConfiguration {
        StandardSimpleDiscoveryClientConfiguration(InetUtils inet) {
            super(inet);
        }
    }

    static abstract class SimpleDiscoveryClientConfiguration {
        protected final SimpleDiscoveryProperties simple = new SimpleDiscoveryProperties();
        protected final InetUtils inet;

        SimpleDiscoveryClientConfiguration(InetUtils inet) {
            this.inet = inet;
        }

        @Bean
        @Order
        public DiscoveryClient simpleDiscoveryClient(SimpleDiscoveryProperties properties) {
            return new SimpleDiscoveryClient(properties);
        }

        @Bean
        @ConditionalOnMissingBean
        public SimpleDiscoveryProperties simpleDiscoveryProperties(@Value(value="${spring.application.name:application}") String serviceId) {
            this.simple.getLocal().setServiceId(serviceId);
            this.simple.getLocal().setHost(this.inet.findFirstNonLoopbackHostInfo().getHostname());
            this.simple.getLocal().setPort(this.findPort());
            return this.simple;
        }

        protected int findPort() {
            return 8080;
        }
    }
}

