/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.Status;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;

public class DiscoveryClientHealthIndicator
implements DiscoveryHealthIndicator,
Ordered,
ApplicationListener<InstanceRegisteredEvent<?>> {
    private final ObjectProvider<DiscoveryClient> discoveryClient;
    private final DiscoveryClientHealthIndicatorProperties properties;
    private final Log log = LogFactory.getLog(DiscoveryClientHealthIndicator.class);
    private AtomicBoolean discoveryInitialized = new AtomicBoolean(false);
    private int order = Integer.MIN_VALUE;

    public DiscoveryClientHealthIndicator(ObjectProvider<DiscoveryClient> discoveryClient, DiscoveryClientHealthIndicatorProperties properties) {
        this.discoveryClient = discoveryClient;
        this.properties = properties;
    }

    public void onApplicationEvent(InstanceRegisteredEvent<?> event) {
        if (this.discoveryInitialized.compareAndSet(false, true)) {
            this.log.debug((Object)"Discovery Client has been initialized");
        }
    }

    @Override
    public Health health() {
        Health.Builder builder;
        block5: {
            builder = new Health.Builder();
            if (this.discoveryInitialized.get()) {
                try {
                    String description;
                    DiscoveryClient client = (DiscoveryClient)this.discoveryClient.getIfAvailable();
                    String string = description = this.properties.isIncludeDescription() ? client.description() : "";
                    if (this.properties.isUseServicesQuery()) {
                        List<String> services = client.getServices();
                        builder.status(new Status("UP", description)).withDetail("services", services);
                        break block5;
                    }
                    client.probe();
                    builder.status(new Status("UP", description));
                }
                catch (Exception e) {
                    this.log.error((Object)"Error", (Throwable)e);
                    builder.down((Throwable)e);
                }
            } else {
                builder.status(new Status(Status.UNKNOWN.getCode(), "Discovery Client not initialized"));
            }
        }
        return builder.build();
    }

    @Override
    public String getName() {
        return "discoveryClient";
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

