/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.circuitbreaker.httpservice;

import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.httpservice.CircuitBreakerConfigurerUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.ReactorHttpExchangeAdapter;
import org.springframework.web.service.invoker.ReactorHttpExchangeAdapterDecorator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveCircuitBreakerAdapterDecorator
extends ReactorHttpExchangeAdapterDecorator {
    private static final Log LOG = LogFactory.getLog(ReactiveCircuitBreakerAdapterDecorator.class);
    private final ReactiveCircuitBreaker reactiveCircuitBreaker;
    private final CircuitBreaker circuitBreaker;
    private final Map<String, Class<?>> fallbackClasses;
    private volatile Map<String, Object> fallbackProxies;

    public ReactiveCircuitBreakerAdapterDecorator(ReactorHttpExchangeAdapter delegate, ReactiveCircuitBreaker reactiveCircuitBreaker, CircuitBreaker circuitBreaker, Map<String, Class<?>> fallbackClasses) {
        super((HttpExchangeAdapter)delegate);
        this.reactiveCircuitBreaker = reactiveCircuitBreaker;
        this.circuitBreaker = circuitBreaker;
        this.fallbackClasses = fallbackClasses;
    }

    public void exchange(HttpRequestValues requestValues) {
        this.circuitBreaker.run(() -> {
            super.exchange(requestValues);
            return null;
        }, this.createFallbackHandler(requestValues));
    }

    public HttpHeaders exchangeForHeaders(HttpRequestValues values) {
        Object result = this.circuitBreaker.run(() -> super.exchangeForHeaders(values), this.createFallbackHandler(values));
        return (HttpHeaders)CircuitBreakerConfigurerUtils.castIfPossible(result);
    }

    public <T> @Nullable T exchangeForBody(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        Object result = this.circuitBreaker.run(() -> super.exchangeForBody(values, bodyType), this.createFallbackHandler(values));
        return CircuitBreakerConfigurerUtils.castIfPossible(result);
    }

    public ResponseEntity<Void> exchangeForBodilessEntity(HttpRequestValues values) {
        Object result = this.circuitBreaker.run(() -> super.exchangeForBodilessEntity(values), this.createFallbackHandler(values));
        return (ResponseEntity)CircuitBreakerConfigurerUtils.castIfPossible(result);
    }

    public <T> ResponseEntity<T> exchangeForEntity(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        Object result = this.circuitBreaker.run(() -> super.exchangeForEntity(values, bodyType), this.createFallbackHandler(values));
        return (ResponseEntity)CircuitBreakerConfigurerUtils.castIfPossible(result);
    }

    public Mono<Void> exchangeForMono(HttpRequestValues requestValues) {
        return this.reactiveCircuitBreaker.run(super.exchangeForMono(requestValues), this.createBodyMonoFallbackHandler(requestValues));
    }

    public Mono<HttpHeaders> exchangeForHeadersMono(HttpRequestValues requestValues) {
        return this.reactiveCircuitBreaker.run(super.exchangeForHeadersMono(requestValues), this.createHttpHeadersMonoFallbackHandler(requestValues));
    }

    public <T> Mono<T> exchangeForBodyMono(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.reactiveCircuitBreaker.run(super.exchangeForBodyMono(requestValues, bodyType), this.createBodyMonoFallbackHandler(requestValues));
    }

    public <T> Flux<T> exchangeForBodyFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.reactiveCircuitBreaker.run(super.exchangeForBodyFlux(requestValues, bodyType), this.createBodyFluxFallbackHandler(requestValues));
    }

    public Mono<ResponseEntity<Void>> exchangeForBodilessEntityMono(HttpRequestValues requestValues) {
        return this.reactiveCircuitBreaker.run(super.exchangeForBodilessEntityMono(requestValues), this.createBodyMonoFallbackHandler(requestValues));
    }

    public <T> Mono<ResponseEntity<T>> exchangeForEntityMono(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.reactiveCircuitBreaker.run(super.exchangeForEntityMono(requestValues, bodyType), this.createBodyMonoFallbackHandler(requestValues));
    }

    public <T> Mono<ResponseEntity<Flux<T>>> exchangeForEntityFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.reactiveCircuitBreaker.run(super.exchangeForEntityFlux(requestValues, bodyType), this.createBodyMonoFallbackHandler(requestValues));
    }

    Function<Throwable, Object> createFallbackHandler(HttpRequestValues requestValues) {
        return throwable -> CircuitBreakerConfigurerUtils.getFallback(requestValues, throwable, this.getFallbackProxies(), this.fallbackClasses);
    }

    <T> Function<Throwable, Mono<T>> createBodyMonoFallbackHandler(HttpRequestValues requestValues) {
        if (requestValues.getAttributes().get("spring.cloud.method.return-type").equals(Mono.class)) {
            return throwable -> (Mono)CircuitBreakerConfigurerUtils.castIfPossible(CircuitBreakerConfigurerUtils.getFallback(requestValues, throwable, this.getFallbackProxies(), this.fallbackClasses));
        }
        return throwable -> {
            Object fallback = CircuitBreakerConfigurerUtils.getFallback(requestValues, throwable, this.getFallbackProxies(), this.fallbackClasses);
            if (fallback == null) {
                return Mono.empty();
            }
            return (Mono)CircuitBreakerConfigurerUtils.castIfPossible(Mono.just((Object)fallback));
        };
    }

    <T> Function<Throwable, Flux<T>> createBodyFluxFallbackHandler(HttpRequestValues requestValues) {
        if (requestValues.getAttributes().get("spring.cloud.method.return-type").equals(Flux.class)) {
            return throwable -> (Flux)CircuitBreakerConfigurerUtils.castIfPossible(CircuitBreakerConfigurerUtils.getFallback(requestValues, throwable, this.getFallbackProxies(), this.fallbackClasses));
        }
        return throwable -> {
            Object fallback = CircuitBreakerConfigurerUtils.getFallback(requestValues, throwable, this.getFallbackProxies(), this.fallbackClasses);
            if (fallback == null) {
                return Flux.empty();
            }
            return (Flux)CircuitBreakerConfigurerUtils.castIfPossible(Flux.just((Object)fallback));
        };
    }

    Function<Throwable, Mono<HttpHeaders>> createHttpHeadersMonoFallbackHandler(HttpRequestValues requestValues) {
        if (requestValues.getAttributes().get("spring.cloud.method.return-type").equals(Mono.class)) {
            return throwable -> (Mono)CircuitBreakerConfigurerUtils.castIfPossible(CircuitBreakerConfigurerUtils.getFallback(requestValues, throwable, this.getFallbackProxies(), this.fallbackClasses));
        }
        return throwable -> {
            Object fallback = CircuitBreakerConfigurerUtils.getFallback(requestValues, throwable, this.getFallbackProxies(), this.fallbackClasses);
            if (fallback == null) {
                return Mono.empty();
            }
            return (Mono)CircuitBreakerConfigurerUtils.castIfPossible(Mono.just((Object)fallback));
        };
    }

    ReactiveCircuitBreaker getReactiveCircuitBreaker() {
        return this.reactiveCircuitBreaker;
    }

    CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    Map<String, Class<?>> getFallbackClasses() {
        return this.fallbackClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getFallbackProxies() {
        if (this.fallbackProxies == null) {
            ReactiveCircuitBreakerAdapterDecorator reactiveCircuitBreakerAdapterDecorator = this;
            synchronized (reactiveCircuitBreakerAdapterDecorator) {
                if (this.fallbackProxies == null) {
                    this.fallbackProxies = CircuitBreakerConfigurerUtils.createProxies(this.fallbackClasses);
                }
            }
        }
        return this.fallbackProxies;
    }
}

