/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4jBulkheadProvider;
import org.springframework.cloud.client.circuitbreaker.Customizer;

public class Resilience4JCircuitBreaker
implements org.springframework.cloud.client.circuitbreaker.CircuitBreaker {
    static final String CIRCUIT_BREAKER_GROUP_TAG = "group";
    private final String id;
    private final String groupName;
    private final Map<String, String> tags;
    private @Nullable Resilience4jBulkheadProvider bulkheadProvider;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final CircuitBreakerRegistry registry;
    private final TimeLimiterRegistry timeLimiterRegistry;
    private final TimeLimiterConfig timeLimiterConfig;
    private final @Nullable ExecutorService executorService;
    private final Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer;
    private final boolean disableTimeLimiter;

    public Resilience4JCircuitBreaker(String id, String groupName, CircuitBreakerConfig circuitBreakerConfig, TimeLimiterConfig timeLimiterConfig, CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, @Nullable ExecutorService executorService, Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer, @Nullable Resilience4jBulkheadProvider bulkheadProvider, boolean disableTimeLimiter) {
        this.id = id;
        this.groupName = groupName;
        this.circuitBreakerConfig = circuitBreakerConfig;
        this.registry = circuitBreakerRegistry;
        this.timeLimiterRegistry = timeLimiterRegistry;
        this.timeLimiterConfig = timeLimiterConfig;
        this.executorService = executorService;
        this.circuitBreakerCustomizer = circuitBreakerCustomizer;
        this.bulkheadProvider = bulkheadProvider;
        this.disableTimeLimiter = disableTimeLimiter;
        this.tags = Map.of(CIRCUIT_BREAKER_GROUP_TAG, this.groupName);
    }

    public Resilience4JCircuitBreaker(String id, String groupName, CircuitBreakerConfig circuitBreakerConfig, TimeLimiterConfig timeLimiterConfig, CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer, @Nullable Resilience4jBulkheadProvider bulkheadProvider) {
        this(id, groupName, circuitBreakerConfig, timeLimiterConfig, circuitBreakerRegistry, timeLimiterRegistry, null, circuitBreakerCustomizer, bulkheadProvider, false);
    }

    public <T> T run(Supplier<T> toRun, Function<@Nullable Throwable, T> fallback) {
        Map<String, String> tags = Map.of(CIRCUIT_BREAKER_GROUP_TAG, this.groupName);
        Optional<TimeLimiter> timeLimiter = this.loadTimeLimiter();
        CircuitBreaker defaultCircuitBreaker = this.registry.circuitBreaker(this.id, this.circuitBreakerConfig, tags);
        this.circuitBreakerCustomizer.ifPresent(customizer -> customizer.customize((Object)defaultCircuitBreaker));
        if (this.bulkheadProvider != null) {
            if (this.executorService != null) {
                Supplier<Future> futureSupplier = () -> this.executorService.submit(((Supplier)toRun)::get);
                Callable<Object> timeLimitedCall = timeLimiter.map(tl -> TimeLimiter.decorateFutureSupplier((TimeLimiter)tl, (Supplier)futureSupplier)).orElse(() -> ((Future)futureSupplier.get()).get());
                Callable<Object> bulkheadCall = this.bulkheadProvider.decorateCallable(this.groupName, tags, timeLimitedCall);
                Callable circuitBreakerCall = CircuitBreaker.decorateCallable((CircuitBreaker)defaultCircuitBreaker, bulkheadCall);
                return Resilience4JCircuitBreaker.getAndApplyFallback(circuitBreakerCall, fallback);
            }
            Callable<Object> bulkheadCall = this.bulkheadProvider.decorateCallable(this.groupName, tags, toRun::get);
            Callable circuitBreakerCall = CircuitBreaker.decorateCallable((CircuitBreaker)defaultCircuitBreaker, bulkheadCall);
            return Resilience4JCircuitBreaker.getAndApplyFallback(circuitBreakerCall, fallback);
        }
        if (this.executorService != null) {
            Supplier<Future> futureSupplier = () -> this.executorService.submit(((Supplier)toRun)::get);
            Callable<Object> restrictedCall = timeLimiter.map(tl -> TimeLimiter.decorateFutureSupplier((TimeLimiter)tl, (Supplier)futureSupplier)).orElse(() -> ((Future)futureSupplier.get()).get());
            Callable callable = CircuitBreaker.decorateCallable((CircuitBreaker)defaultCircuitBreaker, restrictedCall);
            return Resilience4JCircuitBreaker.getAndApplyFallback(callable, fallback);
        }
        Supplier decorator = CircuitBreaker.decorateSupplier((CircuitBreaker)defaultCircuitBreaker, toRun);
        return Resilience4JCircuitBreaker.getAndApplyFallback(decorator, fallback);
    }

    private static <T> T getAndApplyFallback(Supplier<T> supplier, Function<@Nullable Throwable, T> fallback) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            return fallback.apply(t);
        }
    }

    private static <T> T getAndApplyFallback(Callable<T> callable, Function<@Nullable Throwable, T> fallback) {
        try {
            return callable.call();
        }
        catch (Throwable t) {
            return fallback.apply(t);
        }
    }

    private Optional<TimeLimiter> loadTimeLimiter() {
        if (this.disableTimeLimiter) {
            return Optional.empty();
        }
        return Optional.of(this.timeLimiterRegistry.find(this.id).orElseGet(() -> this.timeLimiterRegistry.find(this.groupName).orElseGet(() -> this.timeLimiterRegistry.timeLimiter(this.id, this.timeLimiterConfig, this.tags))));
    }
}

