/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bus.BusBridge;
import org.springframework.cloud.bus.BusConsumer;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.RemoteApplicationEventListener;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.endpoint.EnvironmentBusEndpoint;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.event.EnvironmentChangeListener;
import org.springframework.cloud.bus.event.PathDestinationFactory;
import org.springframework.cloud.bus.event.TraceListener;
import org.springframework.cloud.context.environment.EnvironmentManager;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBusEnabled
@EnableConfigurationProperties(value={BusProperties.class})
public class BusAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Destination.Factory.class})
    public PathDestinationFactory pathDestinationFactory() {
        return new PathDestinationFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public RemoteApplicationEventListener busRemoteApplicationEventListener(ServiceMatcher serviceMatcher, BusBridge busBridge) {
        return new RemoteApplicationEventListener(serviceMatcher, busBridge);
    }

    @Bean
    @ConditionalOnMissingBean(name={"busConsumer"})
    public BusConsumer busConsumer(ApplicationEventPublisher applicationEventPublisher, ServiceMatcher serviceMatcher, ObjectProvider<BusBridge> busBridge, BusProperties properties, Destination.Factory destinationFactory) {
        return new BusConsumer(applicationEventPublisher, serviceMatcher, busBridge, properties, destinationFactory);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EnvironmentManager.class})
    @ConditionalOnBean(value={EnvironmentManager.class})
    protected static class BusEnvironmentConfiguration {
        protected BusEnvironmentConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.bus.env.enabled"}, matchIfMissing=true)
        public EnvironmentChangeListener environmentChangeListener() {
            return new EnvironmentChangeListener();
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={Endpoint.class})
        protected static class EnvironmentBusEndpointConfiguration {
            protected EnvironmentBusEndpointConfiguration() {
            }

            @Bean
            @ConditionalOnAvailableEndpoint
            public EnvironmentBusEndpoint environmentBusEndpoint(ApplicationEventPublisher publisher, BusProperties bus, Destination.Factory destinationFactory) {
                return new EnvironmentBusEndpoint(publisher, bus.getId(), destinationFactory);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Endpoint.class})
    @ConditionalOnBean(value={HttpExchangeRepository.class})
    @ConditionalOnProperty(value={"spring.cloud.bus.trace.enabled"})
    protected static class BusAckTraceConfiguration {
        protected BusAckTraceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TraceListener ackTraceListener(HttpExchangeRepository repository) {
            return new TraceListener(repository);
        }
    }
}

