/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.consumer.jdbc;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class ShorthandMapConverter
implements Converter<String, Map<String, String>> {
    public Map<String, String> convert(String source) {
        String[] mappings;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String mapping : mappings = source.split("(?<!\\\\),")) {
            String unescaped = mapping.trim().replace("\\,", ",");
            if (unescaped.length() == 0) continue;
            String[] keyValuePair = unescaped.split("(?<!\\\\):");
            Assert.isTrue((keyValuePair.length <= 2 ? 1 : 0) != 0, (String)("'" + unescaped + "' could not be parsed to a 'key:value' pair or simple 'key' with implicit value"));
            String key = keyValuePair[0].trim().replace("\\:", ":");
            String value = keyValuePair.length == 2 ? keyValuePair[1].trim().replace("\\:", ":") : key;
            result.put(key, value);
        }
        return result;
    }
}

