/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.fn.consumer.jdbc;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.fn.consumer.jdbc.DefaultInitializationScriptResource;
import org.springframework.cloud.fn.consumer.jdbc.JdbcConsumerProperties;
import org.springframework.cloud.fn.consumer.jdbc.ShorthandMapConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.SpelParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.MessageCountReleaseStrategy;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.config.AggregatorFactoryBean;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.jdbc.JdbcMessageHandler;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.json.JsonPropertyAccessor;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.SimpleMessageStore;
import org.springframework.integration.support.MutableMessage;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Configuration
@EnableConfigurationProperties(value={JdbcConsumerProperties.class})
public class JdbcConsumerConfiguration {
    private static final Log logger = LogFactory.getLog(JdbcConsumerConfiguration.class);
    private static final Object NOT_SET = new Object();
    private final JdbcConsumerProperties properties;
    private SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    private EvaluationContext evaluationContext;

    public JdbcConsumerConfiguration(JdbcConsumerProperties properties, BeanFactory beanFactory) {
        this.properties = properties;
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)beanFactory);
        StandardEvaluationContext standardEvaluationContext = (StandardEvaluationContext)this.evaluationContext;
        standardEvaluationContext.addPropertyAccessor((PropertyAccessor)new JsonPropertyAccessor());
    }

    @Bean
    public static ShorthandMapConverter shorthandMapConverter() {
        return new ShorthandMapConverter();
    }

    private static boolean convertibleContentType(String contentType) {
        return contentType.contains("text") || contentType.contains("json") || contentType.contains("x-spring-tuple");
    }

    private static String generateSql(String tableName, Set<String> columns) {
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        StringBuilder questionMarks = new StringBuilder(") VALUES (");
        builder.append(tableName).append("(");
        int i = 0;
        for (String column : columns) {
            if (i++ > 0) {
                builder.append(", ");
                questionMarks.append(", ");
            }
            builder.append(column);
            questionMarks.append(':').append(column);
        }
        builder.append((CharSequence)questionMarks).append(")");
        return builder.toString();
    }

    @Bean
    IntegrationFlow jdbcConsumerFlow(@Qualifier(value="aggregator") MessageHandler aggregator, JdbcMessageHandler jdbcMessageHandler) {
        IntegrationFlowBuilder builder = IntegrationFlows.from(Consumer.class, gateway -> gateway.beanName("jdbcConsumer"));
        if (this.properties.getBatchSize() > 1 || this.properties.getIdleTimeout() > 0L) {
            builder.handle(aggregator);
        }
        return ((IntegrationFlowBuilder)builder.handle((MessageHandler)jdbcMessageHandler)).get();
    }

    @Bean
    FactoryBean<MessageHandler> aggregator(MessageGroupStore messageGroupStore) {
        AggregatorFactoryBean aggregatorFactoryBean = new AggregatorFactoryBean();
        aggregatorFactoryBean.setCorrelationStrategy(message -> message.getPayload().getClass().getName());
        aggregatorFactoryBean.setReleaseStrategy((ReleaseStrategy)new MessageCountReleaseStrategy(this.properties.getBatchSize()));
        if (this.properties.getIdleTimeout() >= 0L) {
            aggregatorFactoryBean.setGroupTimeoutExpression((Expression)new ValueExpression((Object)this.properties.getIdleTimeout()));
        }
        aggregatorFactoryBean.setMessageStore(messageGroupStore);
        aggregatorFactoryBean.setProcessorBean((Object)new DefaultAggregatingMessageGroupProcessor());
        aggregatorFactoryBean.setExpireGroupsUponCompletion(Boolean.valueOf(true));
        aggregatorFactoryBean.setSendPartialResultOnExpiry(Boolean.valueOf(true));
        return aggregatorFactoryBean;
    }

    @Bean
    MessageGroupStore messageGroupStore() {
        SimpleMessageStore messageGroupStore = new SimpleMessageStore();
        messageGroupStore.setTimeoutOnIdle(true);
        messageGroupStore.setCopyOnGet(false);
        return messageGroupStore;
    }

    @Bean
    public JdbcMessageHandler jdbcMessageHandler(DataSource dataSource) {
        LinkedMultiValueMap columnExpressionVariations = new LinkedMultiValueMap();
        for (Map.Entry<String, String> entry : this.properties.getColumnsMap().entrySet()) {
            String value = entry.getValue();
            columnExpressionVariations.add((Object)entry.getKey(), (Object)this.spelExpressionParser.parseExpression(value));
            if (value.startsWith("payload")) continue;
            String qualified = "payload." + value;
            try {
                columnExpressionVariations.add((Object)entry.getKey(), (Object)this.spelExpressionParser.parseExpression(qualified));
            }
            catch (SpelParseException e) {
                logger.info((Object)("failed to parse qualified fallback expression " + qualified + "; be sure your expression uses the 'payload.' prefix where necessary"));
            }
        }
        JdbcMessageHandler jdbcMessageHandler = new JdbcMessageHandler(dataSource, JdbcConsumerConfiguration.generateSql(this.properties.getTableName(), columnExpressionVariations.keySet())){

            protected void handleMessageInternal(Message<?> message) {
                MutableMessage convertedMessage = message;
                if (message.getPayload() instanceof byte[] || message.getPayload() instanceof Iterable) {
                    String contentType;
                    String string = contentType = message.getHeaders().containsKey((Object)"contentType") ? message.getHeaders().get((Object)"contentType").toString() : "application/json";
                    if (message.getPayload() instanceof Iterable) {
                        Stream<Object> messageStream = StreamSupport.stream(((Iterable)message.getPayload()).spliterator(), false).map(payload -> {
                            if (payload instanceof byte[]) {
                                return JdbcConsumerConfiguration.convertibleContentType(contentType) ? new String((byte[])payload) : payload;
                            }
                            return payload;
                        });
                        convertedMessage = new MutableMessage(messageStream.collect(Collectors.toList()), (Map)message.getHeaders());
                    } else if (JdbcConsumerConfiguration.convertibleContentType(contentType)) {
                        convertedMessage = new MutableMessage((Object)new String((byte[])message.getPayload()), (Map)message.getHeaders());
                    }
                }
                super.handleMessageInternal(convertedMessage);
            }
        };
        ParameterFactory parameterSourceFactory = new ParameterFactory((MultiValueMap<String, Expression>)columnExpressionVariations, this.evaluationContext);
        jdbcMessageHandler.setSqlParameterSourceFactory((SqlParameterSourceFactory)parameterSourceFactory);
        return jdbcMessageHandler;
    }

    @ConditionalOnProperty(value={"jdbc.consumer.initialize"})
    @Bean
    public DataSourceInitializer nonBootDataSourceInitializer(DataSource dataSource, ResourceLoader resourceLoader) {
        DataSourceInitializer dataSourceInitializer = new DataSourceInitializer();
        dataSourceInitializer.setDataSource(dataSource);
        ResourceDatabasePopulator databasePopulator = new ResourceDatabasePopulator();
        databasePopulator.setIgnoreFailedDrops(true);
        dataSourceInitializer.setDatabasePopulator((DatabasePopulator)databasePopulator);
        if ("true".equals(this.properties.getInitialize())) {
            databasePopulator.addScript((Resource)new DefaultInitializationScriptResource(this.properties.getTableName(), this.properties.getColumnsMap().keySet()));
        } else {
            databasePopulator.addScript(resourceLoader.getResource(this.properties.getInitialize()));
        }
        return dataSourceInitializer;
    }

    private static final class ParameterFactory
    implements SqlParameterSourceFactory {
        private final MultiValueMap<String, Expression> columnExpressions;
        private final EvaluationContext context;

        ParameterFactory(MultiValueMap<String, Expression> columnExpressions, EvaluationContext context) {
            this.columnExpressions = columnExpressions;
            this.context = context;
        }

        public SqlParameterSource createParameterSource(Object o) {
            if (!(o instanceof Message)) {
                throw new IllegalArgumentException("Unable to handle type " + o.getClass().getName());
            }
            Message message = (Message)o;
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            for (Map.Entry entry : this.columnExpressions.entrySet()) {
                String key = (String)entry.getKey();
                List spels = (List)entry.getValue();
                Object value = NOT_SET;
                EvaluationException lastException = null;
                for (Expression spel : spels) {
                    try {
                        value = spel.getValue(this.context, (Object)message);
                        break;
                    }
                    catch (EvaluationException e) {
                        lastException = e;
                    }
                }
                if (value == NOT_SET) {
                    if (lastException != null) {
                        logger.info((Object)("Could not find value for column '" + key + "': " + lastException.getMessage()));
                    }
                    parameterSource.addValue(key, null);
                    continue;
                }
                parameterSource.addValue(key, value);
            }
            return parameterSource;
        }
    }
}

