/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.util.Assert;

class AliasedConfigurationPropertySource
implements ConfigurationPropertySource {
    private final ConfigurationPropertySource source;
    private final ConfigurationPropertyNameAliases aliases;

    AliasedConfigurationPropertySource(ConfigurationPropertySource source, ConfigurationPropertyNameAliases aliases) {
        Assert.notNull((Object)source, (String)"'source' must not be null");
        Assert.notNull((Object)aliases, (String)"'aliases' must not be null");
        this.source = source;
        this.aliases = aliases;
    }

    @Override
    public @Nullable ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        ConfigurationProperty result = this.getSource().getConfigurationProperty(name);
        if (result == null) {
            ConfigurationPropertyName aliasedName = this.getAliases().getNameForAlias(name);
            result = aliasedName != null ? this.getSource().getConfigurationProperty(aliasedName) : null;
        }
        return result;
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        ConfigurationPropertyState result = this.source.containsDescendantOf(name);
        if (result != ConfigurationPropertyState.ABSENT) {
            return result;
        }
        for (ConfigurationPropertyName alias : this.getAliases().getAliases(name)) {
            ConfigurationPropertyState aliasResult = this.source.containsDescendantOf(alias);
            if (aliasResult == ConfigurationPropertyState.ABSENT) continue;
            return aliasResult;
        }
        for (ConfigurationPropertyName from : this.getAliases()) {
            for (ConfigurationPropertyName alias : this.getAliases().getAliases(from)) {
                if (!name.isAncestorOf(alias) || this.source.getConfigurationProperty(from) == null) continue;
                return ConfigurationPropertyState.PRESENT;
            }
        }
        return ConfigurationPropertyState.ABSENT;
    }

    @Override
    public @Nullable Object getUnderlyingSource() {
        return this.source.getUnderlyingSource();
    }

    protected ConfigurationPropertySource getSource() {
        return this.source;
    }

    protected ConfigurationPropertyNameAliases getAliases() {
        return this.aliases;
    }
}

