/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import org.apache.catalina.connector.Connector;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class SslConnectorCustomizer
implements TomcatConnectorCustomizer {
    private final Ssl.ClientAuth clientAuth;
    private final SslBundle sslBundle;

    SslConnectorCustomizer(Ssl.ClientAuth clientAuth, SslBundle sslBundle) {
        this.clientAuth = clientAuth;
        this.sslBundle = sslBundle;
    }

    @Override
    public void customize(Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        Assert.state((boolean)(handler instanceof AbstractHttp11JsseProtocol), (String)"To use SSL, the connector's protocol handler must be an AbstractHttp11JsseProtocol subclass");
        this.configureSsl((AbstractHttp11JsseProtocol)handler);
        connector.setScheme("https");
        connector.setSecure(true);
    }

    void configureSsl(AbstractHttp11JsseProtocol<?> protocol) {
        SslBundleKey key = this.sslBundle.getKey();
        SslStoreBundle stores = this.sslBundle.getStores();
        SslOptions options = this.sslBundle.getOptions();
        protocol.setSSLEnabled(true);
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        sslHostConfig.setHostName(protocol.getDefaultSSLHostConfigName());
        sslHostConfig.setSslProtocol(this.sslBundle.getProtocol());
        protocol.addSslHostConfig(sslHostConfig);
        this.configureSslClientAuth(sslHostConfig);
        SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
        String keystorePassword = stores.getKeyStorePassword() != null ? stores.getKeyStorePassword() : "";
        certificate.setCertificateKeystorePassword(keystorePassword);
        if (key.getPassword() != null) {
            certificate.setCertificateKeyPassword(key.getPassword());
        }
        if (key.getAlias() != null) {
            certificate.setCertificateKeyAlias(key.getAlias());
        }
        sslHostConfig.addCertificate(certificate);
        if (options.getCiphers() != null) {
            String ciphers = StringUtils.arrayToCommaDelimitedString((Object[])options.getCiphers());
            sslHostConfig.setCiphers(ciphers);
        }
        this.configureEnabledProtocols(protocol);
        this.configureSslStoreProvider(protocol, sslHostConfig, certificate);
    }

    private void configureEnabledProtocols(AbstractHttp11JsseProtocol<?> protocol) {
        SslOptions options = this.sslBundle.getOptions();
        if (options.getEnabledProtocols() != null) {
            String enabledProtocols = StringUtils.arrayToDelimitedString((Object[])options.getEnabledProtocols(), (String)"+");
            for (SSLHostConfig sslHostConfig : protocol.findSslHostConfigs()) {
                sslHostConfig.setProtocols(enabledProtocols);
            }
        }
    }

    private void configureSslClientAuth(SSLHostConfig config) {
        config.setCertificateVerification(Ssl.ClientAuth.map(this.clientAuth, "none", "optional", "required"));
    }

    protected void configureSslStoreProvider(AbstractHttp11JsseProtocol<?> protocol, SSLHostConfig sslHostConfig, SSLHostConfigCertificate certificate) {
        Assert.isInstanceOf(Http11NioProtocol.class, protocol, (String)"SslStoreProvider can only be used with Http11NioProtocol");
        try {
            SslStoreBundle stores = this.sslBundle.getStores();
            if (stores.getKeyStore() != null) {
                certificate.setCertificateKeystore(stores.getKeyStore());
            }
            if (stores.getTrustStore() != null) {
                sslHostConfig.setTrustStore(stores.getTrustStore());
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not load store: " + ex.getMessage(), ex);
        }
    }
}

