/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat;

import jakarta.servlet.ServletException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.catalina.Container;
import org.apache.catalina.Manager;
import org.apache.catalina.SessionIdGenerator;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.session.ManagerBase;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.tomcat.LazySessionIdGenerator;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TomcatEmbeddedContext
extends StandardContext {
    private DeferredStartupExceptions deferredStartupExceptions = DeferredStartupExceptions.NONE;
    private @Nullable MimeMappings mimeMappings;

    public boolean loadOnStartup(Container[] children) {
        return true;
    }

    public void setManager(Manager manager) {
        if (manager instanceof ManagerBase) {
            manager.setSessionIdGenerator((SessionIdGenerator)new LazySessionIdGenerator());
        }
        super.setManager(manager);
    }

    void deferredLoadOnStartup() {
        this.doWithThreadContextClassLoader(this.getLoader().getClassLoader(), () -> this.getLoadOnStartupWrappers(this.findChildren()).forEach(this::load));
    }

    private Stream<Wrapper> getLoadOnStartupWrappers(Container[] children) {
        TreeMap<Integer, List> grouped = new TreeMap<Integer, List>();
        for (Container child : children) {
            Wrapper wrapper = (Wrapper)child;
            int order = wrapper.getLoadOnStartup();
            if (order < 0) continue;
            grouped.computeIfAbsent(order, o -> new ArrayList()).add(wrapper);
        }
        return grouped.values().stream().flatMap(Collection::stream);
    }

    private void load(Wrapper wrapper) {
        try {
            wrapper.load();
        }
        catch (ServletException ex) {
            String message = sm.getString("standardContext.loadOnStartup.loadException", new Object[]{this.getName(), wrapper.getName()});
            if (this.getComputedFailCtxIfServletStartFails()) {
                throw new WebServerException(message, (Throwable)ex);
            }
            this.getLogger().error((Object)message, StandardWrapper.getRootCause((ServletException)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithThreadContextClassLoader(@Nullable ClassLoader classLoader, Runnable code) {
        ClassLoader existingLoader = classLoader != null ? ClassUtils.overrideThreadContextClassLoader((ClassLoader)classLoader) : null;
        try {
            code.run();
        }
        finally {
            if (existingLoader != null) {
                ClassUtils.overrideThreadContextClassLoader((ClassLoader)existingLoader);
            }
        }
    }

    public void setDeferredStartupExceptions(DeferredStartupExceptions deferredStartupExceptions) {
        Assert.notNull((Object)deferredStartupExceptions, (String)"'deferredStartupExceptions' must not be null");
        this.deferredStartupExceptions = deferredStartupExceptions;
    }

    DeferredStartupExceptions getDeferredStartupExceptions() {
        return this.deferredStartupExceptions;
    }

    public void setMimeMappings(MimeMappings mimeMappings) {
        this.mimeMappings = mimeMappings;
    }

    public String[] findMimeMappings() {
        ArrayList<String> mappings = new ArrayList<String>(Arrays.asList(super.findMimeMappings()));
        if (this.mimeMappings != null) {
            this.mimeMappings.forEach(mapping -> mappings.add(mapping.getExtension()));
        }
        return (String[])mappings.toArray(String[]::new);
    }

    public @Nullable String findMimeMapping(String extension) {
        String mimeMapping = super.findMimeMapping(extension);
        if (mimeMapping != null) {
            return mimeMapping;
        }
        return this.mimeMappings != null ? this.mimeMappings.get(extension) : null;
    }

    @FunctionalInterface
    public static interface DeferredStartupExceptions {
        public static final DeferredStartupExceptions NONE = () -> {};

        public void rethrow() throws Exception;
    }
}

