/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactory;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.testcontainers.lifecycle.TestcontainersStartup;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.testcontainers.containers.Container;
import org.testcontainers.lifecycle.Startable;

public abstract class ContainerConnectionDetailsFactory<C extends Container<?>, D extends ConnectionDetails>
implements ConnectionDetailsFactory<ContainerConnectionSource<C>, D> {
    protected static final @Nullable String ANY_CONNECTION_NAME = null;
    private final List<String> connectionNames;
    private final String[] requiredClassNames;

    protected ContainerConnectionDetailsFactory() {
        this(ANY_CONNECTION_NAME, new String[0]);
    }

    protected ContainerConnectionDetailsFactory(@Nullable String connectionName, String ... requiredClassNames) {
        this(Arrays.asList(connectionName), requiredClassNames);
    }

    protected ContainerConnectionDetailsFactory(List<String> connectionNames, String ... requiredClassNames) {
        Assert.notEmpty(connectionNames, (String)"'connectionNames' must not be empty");
        this.connectionNames = connectionNames;
        this.requiredClassNames = requiredClassNames;
    }

    public final @Nullable D getConnectionDetails(ContainerConnectionSource<C> source) {
        if (!this.hasRequiredClasses()) {
            return null;
        }
        try {
            @Nullable Class<?>[] generics = this.resolveGenerics();
            Class<?> requiredContainerType = generics[0];
            Class<?> requiredConnectionDetailsType = generics[1];
            Assert.state((requiredContainerType != null ? 1 : 0) != 0, (String)"'requiredContainerType' must not be null");
            Assert.state((requiredConnectionDetailsType != null ? 1 : 0) != 0, (String)"'requiredConnectionDetailsType' must not be null");
            if (this.sourceAccepts(source, requiredContainerType, requiredConnectionDetailsType)) {
                return this.getContainerConnectionDetails(source);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    protected boolean sourceAccepts(ContainerConnectionSource<C> source, Class<?> requiredContainerType, Class<?> requiredConnectionDetailsType) {
        for (String requiredConnectionName : this.connectionNames) {
            if (!source.accepts(requiredConnectionName, requiredContainerType, requiredConnectionDetailsType)) continue;
            return true;
        }
        return false;
    }

    private boolean hasRequiredClasses() {
        return ObjectUtils.isEmpty((Object[])this.requiredClassNames) || Arrays.stream(this.requiredClassNames).allMatch(requiredClassName -> ClassUtils.isPresent((String)requiredClassName, null));
    }

    private @Nullable Class<?>[] resolveGenerics() {
        return ResolvableType.forClass(ContainerConnectionDetailsFactory.class, this.getClass()).resolveGenerics();
    }

    protected abstract @Nullable D getContainerConnectionDetails(ContainerConnectionSource<C> var1);

    static class ContainerConnectionDetailsFactoriesRuntimeHints
    implements RuntimeHintsRegistrar {
        private static final Log logger = LogFactory.getLog(ContainerConnectionDetailsFactoriesRuntimeHints.class);

        ContainerConnectionDetailsFactoriesRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)classLoader).load(ConnectionDetailsFactory.class, SpringFactoriesLoader.FailureHandler.logging((Log)logger)).stream().flatMap(this::requiredClassNames).forEach(requiredClassName -> hints.reflection().registerTypeIfPresent(classLoader, requiredClassName, new MemberCategory[0]));
        }

        private Stream<String> requiredClassNames(ConnectionDetailsFactory<?, ?> connectionDetailsFactory) {
            Stream<String> stream;
            if (connectionDetailsFactory instanceof ContainerConnectionDetailsFactory) {
                ContainerConnectionDetailsFactory containerConnectionDetailsFactory = (ContainerConnectionDetailsFactory)connectionDetailsFactory;
                stream = Stream.of(containerConnectionDetailsFactory.requiredClassNames);
            } else {
                stream = Stream.empty();
            }
            return stream;
        }
    }

    protected static class ContainerConnectionDetails<C extends Container<?>>
    implements ConnectionDetails,
    OriginProvider,
    InitializingBean,
    ApplicationContextAware {
        private final ContainerConnectionSource<C> source;
        private volatile @Nullable C container;
        private volatile @Nullable SslBundle sslBundle;

        protected ContainerConnectionDetails(ContainerConnectionSource<C> source) {
            Assert.notNull(source, (String)"'source' must not be null");
            this.source = source;
        }

        public void afterPropertiesSet() throws Exception {
            this.container = (Container)this.source.getContainerSupplier().get();
        }

        protected final C getContainer() {
            C container = this.container;
            Assert.state((container != null ? 1 : 0) != 0, (String)"Container cannot be obtained before the connection details bean has been initialized");
            if (container instanceof Startable) {
                Startable startable = (Startable)container;
                TestcontainersStartup.start(startable);
            }
            return container;
        }

        protected @Nullable SslBundle getSslBundle() {
            if (this.source.getSslBundleSource() == null) {
                return null;
            }
            SslBundle sslBundle = this.sslBundle;
            if (sslBundle == null) {
                this.sslBundle = sslBundle = this.source.getSslBundleSource().getSslBundle();
            }
            return sslBundle;
        }

        protected boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return this.source.hasAnnotation(annotationType);
        }

        public Origin getOrigin() {
            return this.source.getOrigin();
        }

        @Deprecated(since="3.4.0", forRemoval=true)
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        }
    }
}

