/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.activemq;

import org.springframework.boot.autoconfigure.jms.artemis.ArtemisConnectionDetails;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisMode;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.activemq.ArtemisContainer;

class ArtemisContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<ArtemisContainer, ArtemisConnectionDetails> {
    ArtemisContainerConnectionDetailsFactory() {
    }

    @Override
    protected ArtemisConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<ArtemisContainer> source) {
        return new ArtemisContainerConnectionDetails(source);
    }

    private static final class ArtemisContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<ArtemisContainer>
    implements ArtemisConnectionDetails {
        private ArtemisContainerConnectionDetails(ContainerConnectionSource<ArtemisContainer> source) {
            super(source);
        }

        public ArtemisMode getMode() {
            return ArtemisMode.NATIVE;
        }

        public String getBrokerUrl() {
            return ((ArtemisContainer)this.getContainer()).getBrokerUrl();
        }

        public String getUser() {
            return ((ArtemisContainer)this.getContainer()).getUser();
        }

        public String getPassword() {
            return ((ArtemisContainer)this.getContainer()).getPassword();
        }
    }
}

