/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.context;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.testcontainers.properties.TestcontainersPropertySource;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.Environment;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.DynamicPropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class DynamicPropertySourceMethodsImporter {
    private final Environment environment;

    DynamicPropertySourceMethodsImporter(Environment environment) {
        this.environment = environment;
    }

    void registerDynamicPropertySources(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> definitionClass) {
        Set methods = MethodIntrospector.selectMethods(definitionClass, this::isAnnotated);
        if (methods.isEmpty()) {
            return;
        }
        DynamicPropertyRegistry dynamicPropertyRegistry = TestcontainersPropertySource.attach(this.environment, beanDefinitionRegistry);
        methods.forEach(method -> {
            this.assertValid((Method)method);
            ReflectionUtils.makeAccessible((Method)method);
            ReflectionUtils.invokeMethod((Method)method, null, (Object[])new Object[]{dynamicPropertyRegistry});
        });
    }

    private boolean isAnnotated(Method method) {
        return MergedAnnotations.from((AnnotatedElement)method).isPresent(DynamicPropertySource.class);
    }

    private void assertValid(Method method) {
        Assert.state((boolean)Modifier.isStatic(method.getModifiers()), () -> "@DynamicPropertySource method '" + method.getName() + "' must be static");
        Class<?>[] types = method.getParameterTypes();
        Assert.state((types.length == 1 && types[0] == DynamicPropertyRegistry.class ? 1 : 0) != 0, () -> "@DynamicPropertySource method '" + method.getName() + "' must accept a single DynamicPropertyRegistry argument");
    }
}

