/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class SpyDefinition
extends Definition {
    private static final int MULTIPLIER = 31;
    private final ResolvableType typeToSpy;

    SpyDefinition(String name, ResolvableType typeToSpy, MockReset reset, boolean proxyTargetAware, QualifierDefinition qualifier) {
        super(name, reset, proxyTargetAware, qualifier);
        Assert.notNull((Object)typeToSpy, (String)"TypeToSpy must not be null");
        this.typeToSpy = typeToSpy;
    }

    public ResolvableType getTypeToSpy() {
        return this.typeToSpy;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.typeToSpy);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SpyDefinition other = (SpyDefinition)obj;
        boolean result = super.equals(obj);
        result = result && ObjectUtils.nullSafeEquals((Object)this.typeToSpy, (Object)other.typeToSpy);
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.getName()).append("typeToSpy", (Object)this.typeToSpy).append("reset", (Object)this.getReset()).toString();
    }

    public <T> T createSpy(Object instance) {
        return this.createSpy(this.getName(), instance);
    }

    public <T> T createSpy(String name, Object instance) {
        Assert.notNull((Object)instance, (String)"Instance must not be null");
        Assert.isInstanceOf((Class)this.typeToSpy.resolve(), (Object)instance);
        if (Mockito.mockingDetails((Object)instance).isSpy()) {
            return (T)instance;
        }
        MockSettings settings = MockReset.withSettings(this.getReset());
        if (StringUtils.hasLength((String)name)) {
            settings.name(name);
        }
        settings.spiedInstance(instance);
        settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
        return (T)Mockito.mock(instance.getClass(), (MockSettings)settings);
    }
}

