/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.reactor.netty.autoconfigure;

import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.reactor.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.reactor.netty.NettyRouteProvider;
import org.springframework.boot.reactor.netty.NettyServerCustomizer;
import org.springframework.boot.reactor.netty.autoconfigure.NettyReactiveWebServerFactoryCustomizer;
import org.springframework.boot.reactor.netty.autoconfigure.NettyServerProperties;
import org.springframework.boot.reactor.netty.autoconfigure.ReactorNettyConfigurations;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.web.server.autoconfigure.reactive.ReactiveWebServerConfiguration;
import org.springframework.boot.web.server.reactive.ReactiveWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.client.ReactorResourceFactory;
import reactor.netty.http.server.HttpServer;

@AutoConfiguration
@ConditionalOnClass(value={ReactiveHttpInputMessage.class, HttpServer.class})
@EnableConfigurationProperties(value={NettyServerProperties.class})
@Import(value={ReactiveWebServerConfiguration.class, ReactorNettyConfigurations.ReactorResourceFactoryConfiguration.class})
public final class NettyReactiveWebServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
    NettyReactiveWebServerFactory nettyReactiveWebServerFactory(ReactorResourceFactory resourceFactory, ObjectProvider<NettyRouteProvider> routes, ObjectProvider<NettyServerCustomizer> serverCustomizers) {
        NettyReactiveWebServerFactory serverFactory = new NettyReactiveWebServerFactory();
        serverFactory.setResourceFactory(resourceFactory);
        Stream stream = routes.orderedStream();
        NettyReactiveWebServerFactory nettyReactiveWebServerFactory = serverFactory;
        Objects.requireNonNull(nettyReactiveWebServerFactory);
        NettyReactiveWebServerFactory nettyReactiveWebServerFactory2 = nettyReactiveWebServerFactory;
        stream.forEach(xva$0 -> nettyReactiveWebServerFactory2.addRouteProviders((NettyRouteProvider)xva$0));
        serverFactory.getServerCustomizers().addAll(serverCustomizers.orderedStream().toList());
        return serverFactory;
    }

    @Bean
    NettyReactiveWebServerFactoryCustomizer nettyWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties, NettyServerProperties nettyProperties) {
        return new NettyReactiveWebServerFactoryCustomizer(environment, serverProperties, nettyProperties);
    }
}

