/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mongodb.health;

import com.mongodb.client.MongoClient;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.util.Assert;

public class MongoHealthIndicator
extends AbstractHealthIndicator {
    private static final Document HELLO_COMMAND = Document.parse((String)"{ hello: 1 }");
    private final MongoClient mongoClient;

    public MongoHealthIndicator(MongoClient mongoClient) {
        super("MongoDB health check failed");
        Assert.notNull((Object)mongoClient, (String)"'mongoClient' must not be null");
        this.mongoClient = mongoClient;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        LinkedHashMap details = new LinkedHashMap();
        ArrayList databases = new ArrayList();
        details.put("databases", databases);
        this.mongoClient.listDatabaseNames().forEach(database -> {
            Document result = this.mongoClient.getDatabase(database).runCommand((Bson)HELLO_COMMAND);
            databases.add(database);
            details.putIfAbsent("maxWireVersion", result.getInteger((Object)"maxWireVersion"));
        });
        builder.up().withDetails(details);
    }
}

