/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.util.Arrays;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jspecify.annotations.Nullable;
import org.springframework.lang.Contract;

class JavaCompilerPluginConfiguration {
    private final MavenProject project;

    JavaCompilerPluginConfiguration(MavenProject project) {
        this.project = project;
    }

    @Nullable String getSourceMajorVersion() {
        String version = this.getConfigurationValue("source");
        if (version == null) {
            version = this.getPropertyValue("maven.compiler.source");
        }
        return this.majorVersionFor(version);
    }

    @Nullable String getTargetMajorVersion() {
        String version = this.getConfigurationValue("target");
        if (version == null) {
            version = this.getPropertyValue("maven.compiler.target");
        }
        return this.majorVersionFor(version);
    }

    @Nullable String getReleaseVersion() {
        String version = this.getConfigurationValue("release");
        if (version == null) {
            version = this.getPropertyValue("maven.compiler.release");
        }
        return this.majorVersionFor(version);
    }

    private @Nullable String getConfigurationValue(String propertyName) {
        Object pluginConfiguration;
        Plugin plugin = this.project.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
        if (plugin != null && (pluginConfiguration = plugin.getConfiguration()) instanceof Xpp3Dom) {
            Xpp3Dom dom = (Xpp3Dom)pluginConfiguration;
            return this.getNodeValue(dom, propertyName);
        }
        return null;
    }

    private @Nullable String getPropertyValue(String propertyName) {
        if (this.project.getProperties().containsKey(propertyName)) {
            return this.project.getProperties().get(propertyName).toString();
        }
        return null;
    }

    private @Nullable String getNodeValue(Xpp3Dom dom, String ... childNames) {
        Xpp3Dom childNode = dom.getChild(childNames[0]);
        if (childNode == null) {
            return null;
        }
        if (childNames.length > 1) {
            return this.getNodeValue(childNode, Arrays.copyOfRange(childNames, 1, childNames.length));
        }
        return childNode.getValue();
    }

    @Contract(value="!null -> !null")
    private @Nullable String majorVersionFor(@Nullable String version) {
        if (version != null && version.startsWith("1.")) {
            return version.substring("1.".length());
        }
        return version;
    }
}

