/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.integration.endpoint;

import java.util.Collection;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.integration.graph.Graph;
import org.springframework.integration.graph.IntegrationGraphServer;
import org.springframework.integration.graph.IntegrationNode;
import org.springframework.integration.graph.LinkNode;

@Endpoint(id="integrationgraph")
public class IntegrationGraphEndpoint {
    private final IntegrationGraphServer graphServer;

    public IntegrationGraphEndpoint(IntegrationGraphServer graphServer) {
        this.graphServer = graphServer;
    }

    @ReadOperation
    public GraphDescriptor graph() {
        return new GraphDescriptor(this.graphServer.getGraph());
    }

    @WriteOperation
    public void rebuild() {
        this.graphServer.rebuild();
    }

    public static class GraphDescriptor
    implements OperationResponseBody {
        private final Map<String, Object> contentDescriptor;
        private final Collection<IntegrationNode> nodes;
        private final Collection<LinkNode> links;

        GraphDescriptor(Graph graph) {
            this.contentDescriptor = graph.contentDescriptor();
            this.nodes = graph.nodes();
            this.links = graph.links();
        }

        public Map<String, Object> getContentDescriptor() {
            return this.contentDescriptor;
        }

        public Collection<IntegrationNode> getNodes() {
            return this.nodes;
        }

        public Collection<LinkNode> getLinks() {
            return this.links;
        }
    }
}

