/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.io.SocketConfig;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.Empty;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.HttpComponentsRedirectStrategy;
import org.springframework.boot.http.client.HttpComponentsSslBundleTlsStrategy;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.util.Assert;

public final class HttpComponentsHttpClientBuilder {
    private final Consumer<HttpClientBuilder> customizer;
    private final Consumer<PoolingHttpClientConnectionManagerBuilder> connectionManagerCustomizer;
    private final Consumer<SocketConfig.Builder> socketConfigCustomizer;
    private final Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer;
    private final TlsSocketStrategyFactory tlsSocketStrategyFactory;

    public HttpComponentsHttpClientBuilder() {
        this(Empty.consumer(), Empty.consumer(), Empty.consumer(), Empty.consumer(), HttpComponentsSslBundleTlsStrategy::get);
    }

    private HttpComponentsHttpClientBuilder(Consumer<HttpClientBuilder> customizer, Consumer<PoolingHttpClientConnectionManagerBuilder> connectionManagerCustomizer, Consumer<SocketConfig.Builder> socketConfigCustomizer, Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer, TlsSocketStrategyFactory tlsSocketStrategyFactory) {
        this.customizer = customizer;
        this.connectionManagerCustomizer = connectionManagerCustomizer;
        this.socketConfigCustomizer = socketConfigCustomizer;
        this.defaultRequestConfigCustomizer = defaultRequestConfigCustomizer;
        this.tlsSocketStrategyFactory = tlsSocketStrategyFactory;
    }

    public HttpComponentsHttpClientBuilder withCustomizer(Consumer<HttpClientBuilder> customizer) {
        Assert.notNull(customizer, (String)"'customizer' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer.andThen(customizer), this.connectionManagerCustomizer, this.socketConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsHttpClientBuilder withConnectionManagerCustomizer(Consumer<PoolingHttpClientConnectionManagerBuilder> connectionManagerCustomizer) {
        Assert.notNull(connectionManagerCustomizer, (String)"'connectionManagerCustomizer' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer, this.connectionManagerCustomizer.andThen(connectionManagerCustomizer), this.socketConfigCustomizer, this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsHttpClientBuilder withSocketConfigCustomizer(Consumer<SocketConfig.Builder> socketConfigCustomizer) {
        Assert.notNull(socketConfigCustomizer, (String)"'socketConfigCustomizer' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer, this.connectionManagerCustomizer, this.socketConfigCustomizer.andThen(socketConfigCustomizer), this.defaultRequestConfigCustomizer, this.tlsSocketStrategyFactory);
    }

    public HttpComponentsHttpClientBuilder withTlsSocketStrategyFactory(TlsSocketStrategyFactory tlsSocketStrategyFactory) {
        Assert.notNull((Object)tlsSocketStrategyFactory, (String)"'tlsSocketStrategyFactory' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer, this.connectionManagerCustomizer, this.socketConfigCustomizer, this.defaultRequestConfigCustomizer, tlsSocketStrategyFactory);
    }

    public HttpComponentsHttpClientBuilder withDefaultRequestConfigCustomizer(Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer) {
        Assert.notNull(defaultRequestConfigCustomizer, (String)"'defaultRequestConfigCustomizer' must not be null");
        return new HttpComponentsHttpClientBuilder(this.customizer, this.connectionManagerCustomizer, this.socketConfigCustomizer, this.defaultRequestConfigCustomizer.andThen(defaultRequestConfigCustomizer), this.tlsSocketStrategyFactory);
    }

    public CloseableHttpClient build(@Nullable HttpClientSettings settings) {
        settings = settings != null ? settings : HttpClientSettings.DEFAULTS;
        Assert.isTrue((settings.connectTimeout() == null ? 1 : 0) != 0, (String)"'settings' must not have a 'connectTimeout'");
        HttpClientBuilder builder = HttpClientBuilder.create().useSystemProperties().setRedirectStrategy(HttpComponentsRedirectStrategy.get(settings.redirects())).setConnectionManager((HttpClientConnectionManager)this.createConnectionManager(settings)).setDefaultRequestConfig(this.createDefaultRequestConfig());
        this.customizer.accept(builder);
        return builder.build();
    }

    private PoolingHttpClientConnectionManager createConnectionManager(HttpClientSettings settings) {
        PoolingHttpClientConnectionManagerBuilder builder = PoolingHttpClientConnectionManagerBuilder.create().useSystemProperties();
        PropertyMapper map = PropertyMapper.get();
        builder.setDefaultSocketConfig(this.createSocketConfig(settings));
        map.from(settings::sslBundle).always().as(this.tlsSocketStrategyFactory::getTlsSocketStrategy).to(arg_0 -> ((PoolingHttpClientConnectionManagerBuilder)builder).setTlsSocketStrategy(arg_0));
        this.connectionManagerCustomizer.accept(builder);
        return builder.build();
    }

    private SocketConfig createSocketConfig(HttpClientSettings settings) {
        SocketConfig.Builder builder = SocketConfig.custom();
        PropertyMapper map = PropertyMapper.get();
        map.from(settings::readTimeout).asInt(Duration::toMillis).to(timeout -> builder.setSoTimeout(timeout.intValue(), TimeUnit.MILLISECONDS));
        this.socketConfigCustomizer.accept(builder);
        return builder.build();
    }

    private RequestConfig createDefaultRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        this.defaultRequestConfigCustomizer.accept(builder);
        return builder.build();
    }

    public static interface TlsSocketStrategyFactory {
        public @Nullable TlsSocketStrategy getTlsSocketStrategy(@Nullable SslBundle var1);
    }
}

