/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.graphql.autoconfigure.servlet;

import graphql.GraphQL;
import jakarta.websocket.server.ServerContainer;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.graphql.autoconfigure.GraphQlAutoConfiguration;
import org.springframework.boot.graphql.autoconfigure.GraphQlCorsProperties;
import org.springframework.boot.graphql.autoconfigure.GraphQlProperties;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.annotation.Order;
import org.springframework.core.log.LogMessage;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.webmvc.GraphQlHttpHandler;
import org.springframework.graphql.server.webmvc.GraphQlRequestPredicates;
import org.springframework.graphql.server.webmvc.GraphQlSseHandler;
import org.springframework.graphql.server.webmvc.GraphQlWebSocketHandler;
import org.springframework.graphql.server.webmvc.GraphiQlHandler;
import org.springframework.graphql.server.webmvc.SchemaHandler;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import org.springframework.web.socket.server.support.WebSocketHandlerMapping;

@AutoConfiguration(after={GraphQlAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={GraphQL.class, GraphQlHttpHandler.class})
@ConditionalOnBean(value={ExecutionGraphQlService.class})
@EnableConfigurationProperties(value={GraphQlCorsProperties.class})
@ImportRuntimeHints(value={GraphiQlResourceHints.class})
public class GraphQlWebMvcAutoConfiguration {
    private static final Log logger = LogFactory.getLog(GraphQlWebMvcAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public GraphQlHttpHandler graphQlHttpHandler(WebGraphQlHandler webGraphQlHandler) {
        return new GraphQlHttpHandler(webGraphQlHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQlSseHandler graphQlSseHandler(WebGraphQlHandler webGraphQlHandler, GraphQlProperties properties) {
        return new GraphQlSseHandler(webGraphQlHandler, properties.getHttp().getSse().getTimeout(), properties.getHttp().getSse().getKeepAlive());
    }

    @Bean
    @ConditionalOnMissingBean
    public WebGraphQlHandler webGraphQlHandler(ExecutionGraphQlService service, ObjectProvider<WebGraphQlInterceptor> interceptors) {
        return WebGraphQlHandler.builder((ExecutionGraphQlService)service).interceptors(interceptors.orderedStream().toList()).build();
    }

    @Bean
    @Order(value=0)
    public RouterFunction<ServerResponse> graphQlRouterFunction(GraphQlHttpHandler httpHandler, GraphQlSseHandler sseHandler, ObjectProvider<GraphQlSource> graphQlSourceProvider, GraphQlProperties properties) {
        String path = properties.getHttp().getPath();
        logger.info((Object)LogMessage.format((String)"GraphQL endpoint HTTP POST %s", (Object)path));
        RouterFunctions.Builder builder = RouterFunctions.route();
        builder.route(GraphQlRequestPredicates.graphQlHttp((String)path), arg_0 -> ((GraphQlHttpHandler)httpHandler).handleRequest(arg_0));
        builder.route(GraphQlRequestPredicates.graphQlSse((String)path), arg_0 -> ((GraphQlSseHandler)sseHandler).handleRequest(arg_0));
        builder.POST(path, this::unsupportedMediaType);
        builder.GET(path, this::onlyAllowPost);
        if (properties.getGraphiql().isEnabled()) {
            GraphiQlHandler graphiQLHandler = new GraphiQlHandler(path, properties.getWebsocket().getPath());
            builder.GET(properties.getGraphiql().getPath(), arg_0 -> ((GraphiQlHandler)graphiQLHandler).handleRequest(arg_0));
        }
        GraphQlSource graphQlSource = (GraphQlSource)graphQlSourceProvider.getIfAvailable();
        if (properties.getSchema().getPrinter().isEnabled() && graphQlSource != null) {
            SchemaHandler schemaHandler = new SchemaHandler(graphQlSource);
            builder.GET(path + "/schema", arg_0 -> ((SchemaHandler)schemaHandler).handleRequest(arg_0));
        }
        return builder.build();
    }

    private ServerResponse unsupportedMediaType(ServerRequest request) {
        return ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE).headers(this::acceptJson)).build();
    }

    private void acceptJson(HttpHeaders headers) {
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
    }

    private ServerResponse onlyAllowPost(ServerRequest request) {
        return ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED).headers(this::onlyAllowPost)).build();
    }

    private void onlyAllowPost(HttpHeaders headers) {
        headers.setAllow(Collections.singleton(HttpMethod.POST));
    }

    static class GraphiQlResourceHints
    implements RuntimeHintsRegistrar {
        GraphiQlResourceHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.resources().registerPattern("graphiql/index.html");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpMessageConverters.class, ServerContainer.class, WebSocketHandler.class})
    @ConditionalOnProperty(value={"spring.graphql.websocket.path"})
    public static class WebSocketConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public GraphQlWebSocketHandler graphQlWebSocketHandler(WebGraphQlHandler webGraphQlHandler, GraphQlProperties properties, HttpMessageConverters converters) {
            return new GraphQlWebSocketHandler(webGraphQlHandler, this.getJsonConverter(converters), properties.getWebsocket().getConnectionInitTimeout(), properties.getWebsocket().getKeepAlive());
        }

        private GenericHttpMessageConverter<Object> getJsonConverter(HttpMessageConverters converters) {
            return converters.getConverters().stream().filter(this::canReadJsonMap).findFirst().map(this::asGenericHttpMessageConverter).orElseThrow(() -> new IllegalStateException("No JSON converter"));
        }

        private boolean canReadJsonMap(HttpMessageConverter<?> candidate) {
            return candidate.canRead(Map.class, MediaType.APPLICATION_JSON);
        }

        private GenericHttpMessageConverter<Object> asGenericHttpMessageConverter(HttpMessageConverter<?> converter) {
            return (GenericHttpMessageConverter)converter;
        }

        @Bean
        public HandlerMapping graphQlWebSocketMapping(GraphQlWebSocketHandler handler, GraphQlProperties properties) {
            String path = properties.getWebsocket().getPath();
            logger.info((Object)LogMessage.format((String)"GraphQL endpoint WebSocket %s", (Object)path));
            WebSocketHandlerMapping mapping = new WebSocketHandlerMapping();
            mapping.setWebSocketUpgradeMatch(true);
            mapping.setUrlMap(Collections.singletonMap(path, handler.initWebSocketHttpRequestHandler((HandshakeHandler)new DefaultHandshakeHandler())));
            mapping.setOrder(-2);
            return mapping;
        }
    }

    @Configuration(proxyBeanMethods=false)
    public static class GraphQlEndpointCorsConfiguration
    implements WebMvcConfigurer {
        final GraphQlProperties graphQlProperties;
        final GraphQlCorsProperties corsProperties;

        public GraphQlEndpointCorsConfiguration(GraphQlProperties graphQlProps, GraphQlCorsProperties corsProps) {
            this.graphQlProperties = graphQlProps;
            this.corsProperties = corsProps;
        }

        public void addCorsMappings(CorsRegistry registry) {
            CorsConfiguration configuration = this.corsProperties.toCorsConfiguration();
            if (configuration != null) {
                registry.addMapping(this.graphQlProperties.getHttp().getPath()).combine(configuration);
            }
        }
    }
}

