/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;

public abstract class DockerSpec {
    private final DockerRegistrySpec builderRegistry;
    private final DockerRegistrySpec publishRegistry;

    @Inject
    public DockerSpec(ObjectFactory objects) {
        this.builderRegistry = (DockerRegistrySpec)objects.newInstance(DockerRegistrySpec.class, new Object[0]);
        this.publishRegistry = (DockerRegistrySpec)objects.newInstance(DockerRegistrySpec.class, new Object[0]);
        this.getBindHostToBuilder().convention((Object)false);
        this.getTlsVerify().convention((Object)false);
    }

    DockerSpec(DockerRegistrySpec builderRegistry, DockerRegistrySpec publishRegistry) {
        this.builderRegistry = builderRegistry;
        this.publishRegistry = publishRegistry;
    }

    @Input
    @Optional
    public abstract Property<String> getContext();

    @Input
    @Optional
    public abstract Property<String> getHost();

    @Input
    @Optional
    public abstract Property<Boolean> getTlsVerify();

    @Input
    @Optional
    public abstract Property<String> getCertPath();

    @Input
    @Optional
    public abstract Property<Boolean> getBindHostToBuilder();

    @Nested
    public DockerRegistrySpec getBuilderRegistry() {
        return this.builderRegistry;
    }

    public void builderRegistry(Action<DockerRegistrySpec> action) {
        action.execute((Object)this.builderRegistry);
    }

    @Nested
    public DockerRegistrySpec getPublishRegistry() {
        return this.publishRegistry;
    }

    public void publishRegistry(Action<DockerRegistrySpec> action) {
        action.execute((Object)this.publishRegistry);
    }

    DockerConfiguration asDockerConfiguration() {
        DockerConfiguration dockerConfiguration = new DockerConfiguration();
        dockerConfiguration = this.customizeHost(dockerConfiguration);
        dockerConfiguration = dockerConfiguration.withBindHostToBuilder(((Boolean)this.getBindHostToBuilder().get()).booleanValue());
        dockerConfiguration = this.customizeBuilderAuthentication(dockerConfiguration);
        dockerConfiguration = this.customizePublishAuthentication(dockerConfiguration);
        return dockerConfiguration;
    }

    private DockerConfiguration customizeHost(DockerConfiguration dockerConfiguration) {
        String context = (String)this.getContext().getOrNull();
        String host = (String)this.getHost().getOrNull();
        if (context != null && host != null) {
            throw new GradleException("Invalid Docker configuration, either context or host can be provided but not both");
        }
        if (context != null) {
            return dockerConfiguration.withContext(context);
        }
        if (host != null) {
            return dockerConfiguration.withHost(host, ((Boolean)this.getTlsVerify().get()).booleanValue(), (String)this.getCertPath().getOrNull());
        }
        return dockerConfiguration;
    }

    private DockerConfiguration customizeBuilderAuthentication(DockerConfiguration dockerConfiguration) {
        if (this.builderRegistry == null || this.builderRegistry.hasEmptyAuth()) {
            return dockerConfiguration;
        }
        if (this.builderRegistry.hasTokenAuth() && !this.builderRegistry.hasUserAuth()) {
            return dockerConfiguration.withBuilderRegistryTokenAuthentication((String)this.builderRegistry.getToken().get());
        }
        if (this.builderRegistry.hasUserAuth() && !this.builderRegistry.hasTokenAuth()) {
            return dockerConfiguration.withBuilderRegistryUserAuthentication((String)this.builderRegistry.getUsername().get(), (String)this.builderRegistry.getPassword().get(), (String)this.builderRegistry.getUrl().getOrNull(), (String)this.builderRegistry.getEmail().getOrNull());
        }
        throw new GradleException("Invalid Docker builder registry configuration, either token or username/password must be provided");
    }

    private DockerConfiguration customizePublishAuthentication(DockerConfiguration dockerConfiguration) {
        if (this.publishRegistry == null || this.publishRegistry.hasEmptyAuth()) {
            return dockerConfiguration.withEmptyPublishRegistryAuthentication();
        }
        if (this.publishRegistry.hasTokenAuth() && !this.publishRegistry.hasUserAuth()) {
            return dockerConfiguration.withPublishRegistryTokenAuthentication((String)this.publishRegistry.getToken().get());
        }
        if (this.publishRegistry.hasUserAuth() && !this.publishRegistry.hasTokenAuth()) {
            return dockerConfiguration.withPublishRegistryUserAuthentication((String)this.publishRegistry.getUsername().get(), (String)this.publishRegistry.getPassword().get(), (String)this.publishRegistry.getUrl().getOrNull(), (String)this.publishRegistry.getEmail().getOrNull());
        }
        throw new GradleException("Invalid Docker publish registry configuration, either token or username/password must be provided");
    }

    public static abstract class DockerRegistrySpec {
        @Input
        @Optional
        public abstract Property<String> getUsername();

        @Input
        @Optional
        public abstract Property<String> getPassword();

        @Input
        @Optional
        public abstract Property<String> getUrl();

        @Input
        @Optional
        public abstract Property<String> getEmail();

        @Input
        @Optional
        public abstract Property<String> getToken();

        boolean hasEmptyAuth() {
            return this.nonePresent(this.getUsername(), this.getPassword(), this.getUrl(), this.getEmail(), this.getToken());
        }

        private boolean nonePresent(Property<?> ... properties) {
            for (Property<?> property : properties) {
                if (!property.isPresent()) continue;
                return false;
            }
            return true;
        }

        boolean hasUserAuth() {
            return this.allPresent(this.getUsername(), this.getPassword());
        }

        private boolean allPresent(Property<?> ... properties) {
            for (Property<?> property : properties) {
                if (property.isPresent()) continue;
                return false;
            }
            return true;
        }

        boolean hasTokenAuth() {
            return this.getToken().isPresent();
        }
    }
}

