/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.lifecycle;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.lifecycle.DockerComposeProperties;
import org.springframework.boot.docker.compose.lifecycle.ReadinessTimeoutException;
import org.springframework.boot.docker.compose.lifecycle.ServiceNotReadyException;
import org.springframework.boot.docker.compose.lifecycle.TcpConnectServiceReadinessCheck;
import org.springframework.core.log.LogMessage;

class ServiceReadinessChecks {
    private static final Log logger = LogFactory.getLog(ServiceReadinessChecks.class);
    private static final String DISABLE_LABEL = "org.springframework.boot.readiness-check.disable";
    private static final Duration SLEEP_BETWEEN_READINESS_TRIES = Duration.ofSeconds(1L);
    private final Clock clock;
    private final Consumer<Duration> sleep;
    private final DockerComposeProperties.Readiness properties;
    private final TcpConnectServiceReadinessCheck check;

    ServiceReadinessChecks(DockerComposeProperties.Readiness properties) {
        this(properties, Clock.systemUTC(), ServiceReadinessChecks::sleep, new TcpConnectServiceReadinessCheck(properties.getTcp()));
    }

    ServiceReadinessChecks(DockerComposeProperties.Readiness properties, Clock clock, Consumer<Duration> sleep, TcpConnectServiceReadinessCheck check) {
        this.clock = clock;
        this.sleep = sleep;
        this.properties = properties;
        this.check = check;
    }

    void waitUntilReady(List<RunningService> runningServices) {
        Duration timeout = this.properties.getTimeout();
        Instant start = this.clock.instant();
        List<ServiceNotReadyException> exceptions;
        while (!(exceptions = this.check(runningServices)).isEmpty()) {
            Duration elapsed = Duration.between(start, this.clock.instant());
            if (elapsed.compareTo(timeout) > 0) {
                throw new ReadinessTimeoutException(timeout, exceptions);
            }
            this.sleep.accept(SLEEP_BETWEEN_READINESS_TRIES);
        }
        return;
    }

    private List<ServiceNotReadyException> check(List<RunningService> runningServices) {
        ArrayList<ServiceNotReadyException> exceptions = null;
        for (RunningService service : runningServices) {
            if (this.isDisabled(service)) continue;
            logger.trace((Object)LogMessage.format((String)"Checking readiness of service '%s'", (Object)service));
            try {
                this.check.check(service);
                logger.trace((Object)LogMessage.format((String)"Service '%s' is ready", (Object)service));
            }
            catch (ServiceNotReadyException ex) {
                logger.trace((Object)LogMessage.format((String)"Service '%s' is not ready", (Object)service), (Throwable)ex);
                exceptions = exceptions != null ? exceptions : new ArrayList<ServiceNotReadyException>();
                exceptions.add(ex);
            }
        }
        return exceptions != null ? exceptions : Collections.emptyList();
    }

    private boolean isDisabled(RunningService service) {
        return service.labels().containsKey(DISABLE_LABEL);
    }

    private static void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

