/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart.classloader;

import java.io.Serializable;
import org.springframework.util.Assert;

public class ClassLoaderFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Kind kind;
    private final byte[] contents;
    private final long lastModified;

    public ClassLoaderFile(Kind kind, byte[] contents) {
        this(kind, System.currentTimeMillis(), contents);
    }

    public ClassLoaderFile(Kind kind, long lastModified, byte[] contents) {
        Assert.notNull((Object)((Object)kind), (String)"'kind' must not be null");
        if (kind == Kind.DELETED) {
            Assert.isTrue((contents == null ? 1 : 0) != 0, (String)"'contents' must be null");
        } else {
            Assert.isTrue((contents != null ? 1 : 0) != 0, (String)"'contents' must not be null");
        }
        this.kind = kind;
        this.lastModified = lastModified;
        this.contents = contents;
    }

    public Kind getKind() {
        return this.kind;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public static enum Kind {
        ADDED,
        MODIFIED,
        DELETED;

    }
}

