/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.testcontainers;

import com.redis.testcontainers.RedisContainer;
import com.redis.testcontainers.RedisStackContainer;
import java.util.List;
import org.springframework.boot.data.redis.autoconfigure.RedisConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class RedisContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, RedisConnectionDetails> {
    private static final List<String> REDIS_IMAGE_NAMES = List.of("redis", "bitnami/redis", "redis/redis-stack", "redis/redis-stack-server");
    private static final int REDIS_PORT = 6379;

    RedisContainerConnectionDetailsFactory() {
        super(REDIS_IMAGE_NAMES, new String[0]);
    }

    protected boolean sourceAccepts(ContainerConnectionSource<Container<?>> source, Class<?> requiredContainerType, Class<?> requiredConnectionDetailsType) {
        return super.sourceAccepts(source, requiredContainerType, requiredConnectionDetailsType) || source.accepts(ContainerConnectionDetailsFactory.ANY_CONNECTION_NAME, RedisContainer.class, requiredConnectionDetailsType) || source.accepts(ContainerConnectionDetailsFactory.ANY_CONNECTION_NAME, RedisStackContainer.class, requiredConnectionDetailsType);
    }

    protected RedisConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new RedisContainerConnectionDetails(source);
    }

    private static final class RedisContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements RedisConnectionDetails {
        private RedisContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        @Override
        public RedisConnectionDetails.Standalone getStandalone() {
            return RedisConnectionDetails.Standalone.of(this.getContainer().getHost(), (int)this.getContainer().getMappedPort(6379), super.getSslBundle());
        }
    }
}

