/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.mongodb.autoconfigure;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.data.mongodb.autoconfigure.DataMongoProperties;
import org.springframework.boot.persistence.autoconfigure.EntityScanner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.domain.ManagedTypes;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoManagedTypes;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.NoOpDbRefResolver;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration(proxyBeanMethods=false)
class MongoDataConfiguration {
    private final DataMongoProperties properties;

    MongoDataConfiguration(DataMongoProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    static MongoManagedTypes mongoManagedTypes(ApplicationContext applicationContext) throws ClassNotFoundException {
        return MongoManagedTypes.fromIterable((Iterable)new EntityScanner(applicationContext).scan(new Class[]{Document.class}));
    }

    @Bean
    @ConditionalOnMissingBean
    MongoMappingContext mongoMappingContext(MongoCustomConversions conversions, MongoManagedTypes managedTypes) {
        PropertyMapper map = PropertyMapper.get();
        MongoMappingContext context = new MongoMappingContext();
        map.from((Object)this.properties.isAutoIndexCreation()).to(arg_0 -> ((MongoMappingContext)context).setAutoIndexCreation(arg_0));
        context.setManagedTypes((ManagedTypes)managedTypes);
        Class<?> strategyClass = this.properties.getFieldNamingStrategy();
        if (strategyClass != null) {
            context.setFieldNamingStrategy((FieldNamingStrategy)BeanUtils.instantiateClass(strategyClass));
        }
        context.setSimpleTypeHolder(conversions.getSimpleTypeHolder());
        return context;
    }

    @Bean
    @ConditionalOnMissingBean
    MongoCustomConversions mongoCustomConversions() {
        return MongoCustomConversions.create(configurer -> {
            MongoCustomConversions.BigDecimalRepresentation bigDecimaRepresentation = this.properties.getRepresentation().getBigDecimal();
            if (bigDecimaRepresentation != null) {
                configurer.bigDecimal(bigDecimaRepresentation);
            }
        });
    }

    @Bean
    @ConditionalOnMissingBean(value={MongoConverter.class})
    MappingMongoConverter mappingMongoConverter(ObjectProvider<MongoDatabaseFactory> factory, MongoMappingContext context, MongoCustomConversions conversions) {
        MongoDatabaseFactory mongoDatabaseFactory = (MongoDatabaseFactory)factory.getIfAvailable();
        NoOpDbRefResolver dbRefResolver = mongoDatabaseFactory != null ? new DefaultDbRefResolver(mongoDatabaseFactory) : NoOpDbRefResolver.INSTANCE;
        MappingMongoConverter mappingConverter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
        mappingConverter.setCustomConversions((CustomConversions)conversions);
        return mappingConverter;
    }
}

