/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.boot.configurationprocessor.MetadataGenerationEnvironment;
import org.springframework.boot.configurationprocessor.ParameterPropertyDescriptor;
import org.springframework.boot.configurationprocessor.metadata.ItemDeprecation;

class ConstructorParameterPropertyDescriptor
extends ParameterPropertyDescriptor {
    private final ExecutableElement setter;
    private final VariableElement field;

    ConstructorParameterPropertyDescriptor(String name, TypeMirror type, VariableElement parameter, TypeElement declaringElement, ExecutableElement getter, ExecutableElement setter, VariableElement field) {
        super(name, type, parameter, declaringElement, getter);
        this.setter = setter;
        this.field = field;
    }

    @Override
    protected ItemDeprecation resolveItemDeprecation(MetadataGenerationEnvironment environment) {
        return this.resolveItemDeprecation(environment, this.getGetter(), this.setter, this.field);
    }

    @Override
    protected boolean isMarkedAsNested(MetadataGenerationEnvironment environment) {
        return environment.getNestedConfigurationPropertyAnnotation(this.field) != null;
    }

    @Override
    protected String resolveDescription(MetadataGenerationEnvironment environment) {
        return environment.getTypeUtils().getJavaDoc(this.field);
    }
}

