/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class ImageConfig
extends MappedObject {
    private final Map<String, String> labels = this.extractLabels();
    private final Map<String, @Nullable String> configEnv = this.parseConfigEnv();

    ImageConfig(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    private Map<String, String> extractLabels() {
        Map labels = this.valueAt("/Labels", Map.class);
        if (labels == null) {
            return Collections.emptyMap();
        }
        return labels;
    }

    private Map<String, @Nullable String> parseConfigEnv() {
        String[] entries = this.valueAt("/Env", String[].class);
        if (entries == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, @Nullable String> env = new LinkedHashMap<String, String>();
        for (String entry : entries) {
            int i = entry.indexOf(61);
            String name = i != -1 ? entry.substring(0, i) : entry;
            String value = i != -1 ? entry.substring(i + 1) : null;
            env.put(name, value);
        }
        return Collections.unmodifiableMap(env);
    }

    JsonNode getNodeCopy() {
        return super.getNode().deepCopy();
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, @Nullable String> getEnv() {
        return this.configEnv;
    }

    public ImageConfig copy(Consumer<Update> update) {
        return new Update(this).run(update);
    }

    public static final class Update {
        private final ObjectNode copy;

        private Update(ImageConfig source) {
            this.copy = (ObjectNode)source.getNode().deepCopy();
        }

        private ImageConfig run(Consumer<Update> update) {
            update.accept(this);
            return new ImageConfig((JsonNode)this.copy);
        }

        public void withLabel(String label, String value) {
            JsonNode labels = this.copy.at("/Labels");
            if (labels.isMissingNode()) {
                labels = this.copy.putObject("Labels");
            }
            ((ObjectNode)labels).put(label, value);
        }
    }
}

