/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.type.BlobReference;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.util.Assert;
import tools.jackson.databind.JsonNode;

public class ManifestList
extends MappedObject {
    private final Integer schemaVersion = this.extractSchemaVersion();
    private final @Nullable String mediaType = this.valueAt("/mediaType", String.class);
    private final List<BlobReference> manifests = this.childrenAt("/manifests", BlobReference::new);

    protected ManifestList(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    private Integer extractSchemaVersion() {
        Integer result = this.valueAt("/schemaVersion", Integer.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"'result' must not be null");
        return result;
    }

    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public @Nullable String getMediaType() {
        return this.mediaType;
    }

    public Stream<BlobReference> streamManifests() {
        return this.getManifests().stream();
    }

    public List<BlobReference> getManifests() {
        return this.manifests;
    }

    public static ManifestList of(InputStream content) throws IOException {
        return ManifestList.of(content, ManifestList::new);
    }
}

