/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.type.Binding;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class ContainerConfig {
    private final String json;

    ContainerConfig(@Nullable String user, ImageReference image, String command, List<String> args, Map<String, String> labels, List<Binding> bindings, Map<String, String> env, @Nullable String networkMode, List<String> securityOptions) {
        Assert.notNull((Object)image, (String)"'image' must not be null");
        Assert.hasText((String)command, (String)"'command' must not be empty");
        ObjectMapper objectMapper = SharedObjectMapper.get();
        ObjectNode node = objectMapper.createObjectNode();
        if (StringUtils.hasText((String)user)) {
            node.put("User", user);
        }
        node.put("Image", image.toString());
        ArrayNode commandNode = node.putArray("Cmd");
        commandNode.add(command);
        args.forEach(arg_0 -> ((ArrayNode)commandNode).add(arg_0));
        ArrayNode envNode = node.putArray("Env");
        env.forEach((name, value) -> envNode.add(name + "=" + value));
        ObjectNode labelsNode = node.putObject("Labels");
        labels.forEach((arg_0, arg_1) -> ((ObjectNode)labelsNode).put(arg_0, arg_1));
        ObjectNode hostConfigNode = node.putObject("HostConfig");
        if (networkMode != null) {
            hostConfigNode.put("NetworkMode", networkMode);
        }
        ArrayNode bindsNode = hostConfigNode.putArray("Binds");
        bindings.forEach(binding -> bindsNode.add(binding.toString()));
        if (!CollectionUtils.isEmpty(securityOptions)) {
            ArrayNode securityOptsNode = hostConfigNode.putArray("SecurityOpt");
            securityOptions.forEach(arg_0 -> ((ArrayNode)securityOptsNode).add(arg_0));
        }
        this.json = objectMapper.writeValueAsString((Object)node);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        StreamUtils.copy((String)this.json, (Charset)StandardCharsets.UTF_8, (OutputStream)outputStream);
    }

    public String toString() {
        return this.json;
    }

    public static ContainerConfig of(ImageReference imageReference, Consumer<Update> update) {
        Assert.notNull((Object)imageReference, (String)"'imageReference' must not be null");
        Assert.notNull(update, (String)"'update' must not be null");
        return new Update(imageReference).run(update);
    }

    public static class Update {
        private final ImageReference image;
        private @Nullable String user;
        private @Nullable String command;
        private final List<String> args = new ArrayList<String>();
        private final Map<String, String> labels = new LinkedHashMap<String, String>();
        private final List<Binding> bindings = new ArrayList<Binding>();
        private final Map<String, String> env = new LinkedHashMap<String, String>();
        private @Nullable String networkMode;
        private final List<String> securityOptions = new ArrayList<String>();

        Update(ImageReference image) {
            this.image = image;
        }

        private ContainerConfig run(Consumer<Update> update) {
            update.accept(this);
            Assert.state((this.command != null ? 1 : 0) != 0, (String)"'command' must not be null");
            return new ContainerConfig(this.user, this.image, this.command, this.args, this.labels, this.bindings, this.env, this.networkMode, this.securityOptions);
        }

        public void withUser(String user) {
            this.user = user;
        }

        public void withCommand(String command, String ... args) {
            this.command = command;
            this.withArgs(args);
        }

        public void withArgs(String ... args) {
            this.args.addAll(Arrays.asList(args));
        }

        public void withLabel(String name, String value) {
            this.labels.put(name, value);
        }

        public void withBinding(Binding binding) {
            this.bindings.add(binding);
        }

        public void withEnv(String name, String value) {
            this.env.put(name, value);
        }

        public void withNetworkMode(@Nullable String networkMode) {
            this.networkMode = networkMode;
        }

        public void withSecurityOption(String option) {
            this.securityOptions.add(option);
        }
    }
}

