/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.springframework.boot.buildpack.platform.docker.ImageProgressUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.ProgressUpdateEvent;
import org.springframework.boot.buildpack.platform.docker.TotalProgressEvent;
import org.springframework.boot.buildpack.platform.docker.UpdateListener;

public abstract class TotalProgressListener<E extends ImageProgressUpdateEvent>
implements UpdateListener<E> {
    private final Map<String, Layer> layers = new ConcurrentHashMap<String, Layer>();
    private final Consumer<TotalProgressEvent> consumer;
    private final String[] trackedStatusKeys;
    private boolean progressStarted;

    protected TotalProgressListener(Consumer<TotalProgressEvent> consumer, String[] trackedStatusKeys) {
        this.consumer = consumer;
        this.trackedStatusKeys = trackedStatusKeys;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onUpdate(E event) {
        if (((ImageProgressUpdateEvent)event).getId() != null) {
            this.layers.computeIfAbsent(((ImageProgressUpdateEvent)event).getId(), value -> new Layer(this.trackedStatusKeys)).update((ImageProgressUpdateEvent)event);
        }
        boolean bl = this.progressStarted = this.progressStarted || ((ProgressUpdateEvent)event).getProgress() != null;
        if (this.progressStarted) {
            this.publish(0);
        }
    }

    @Override
    public void onFinish() {
        this.layers.values().forEach(Layer::finish);
        this.publish(100);
    }

    private void publish(int fallback) {
        int count = 0;
        int total = 0;
        for (Layer layer : this.layers.values()) {
            ++count;
            total += layer.getProgress();
        }
        TotalProgressEvent event = new TotalProgressEvent(count != 0 ? TotalProgressListener.withinPercentageBounds(total / count) : fallback);
        this.consumer.accept(event);
    }

    private static int withinPercentageBounds(int value) {
        return value < 0 ? 0 : Math.min(value, 100);
    }

    private static class Layer {
        private final Map<String, Integer> progressByStatus = new HashMap<String, Integer>();

        Layer(String[] trackedStatusKeys) {
            Arrays.stream(trackedStatusKeys).forEach(status -> this.progressByStatus.put((String)status, 0));
        }

        void update(ImageProgressUpdateEvent event) {
            String status = event.getStatus();
            if (status == null) {
                return;
            }
            if (event.getProgressDetail() != null && this.progressByStatus.containsKey(status)) {
                int current = this.progressByStatus.get(status);
                this.progressByStatus.put(status, this.updateProgress(current, event.getProgressDetail()));
            }
        }

        private int updateProgress(int current, ProgressUpdateEvent.ProgressDetail detail) {
            return Math.max(detail.asPercentage(), current);
        }

        void finish() {
            this.progressByStatus.keySet().forEach(key -> this.progressByStatus.put((String)key, 100));
        }

        int getProgress() {
            return TotalProgressListener.withinPercentageBounds(this.progressByStatus.values().stream().mapToInt(Integer::intValue).sum() / this.progressByStatus.size());
        }
    }
}

