/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CertificateAuthenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.codec.JacksonJsonSerializer;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonValueModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.List;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.couchbase.ClusterEnvironmentBuilderCustomizer;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseConnectionDetails;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseProperties;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.io.ApplicationResourceLoader;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.ssl.pem.PemSslStore;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={JacksonAutoConfiguration.class})
@ConditionalOnClass(value={Cluster.class})
@Conditional(value={CouchbaseCondition.class})
@EnableConfigurationProperties(value={CouchbaseProperties.class})
public class CouchbaseAutoConfiguration {
    private final ResourceLoader resourceLoader;
    private final CouchbaseProperties properties;

    CouchbaseAutoConfiguration(ResourceLoader resourceLoader, CouchbaseProperties properties) {
        this.resourceLoader = ApplicationResourceLoader.get((ResourceLoader)resourceLoader);
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={CouchbaseConnectionDetails.class})
    PropertiesCouchbaseConnectionDetails couchbaseConnectionDetails() {
        return new PropertiesCouchbaseConnectionDetails(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ClusterEnvironment couchbaseClusterEnvironment(ObjectProvider<ClusterEnvironmentBuilderCustomizer> customizers, ObjectProvider<SslBundles> sslBundles) {
        ClusterEnvironment.Builder builder = this.initializeEnvironmentBuilder((SslBundles)sslBundles.getIfAvailable());
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public Authenticator couchbaseAuthenticator(CouchbaseConnectionDetails connectionDetails) throws IOException {
        if (connectionDetails.getUsername() != null && connectionDetails.getPassword() != null) {
            return PasswordAuthenticator.create((String)connectionDetails.getUsername(), (String)connectionDetails.getPassword());
        }
        CouchbaseProperties.Authentication.Pem pem = this.properties.getAuthentication().getPem();
        if (pem.getCertificates() != null) {
            PemSslStoreDetails details = new PemSslStoreDetails(null, pem.getCertificates(), pem.getPrivateKey());
            PemSslStore store = PemSslStore.load((PemSslStoreDetails)details);
            return CertificateAuthenticator.fromKey((PrivateKey)store.privateKey(), (String)pem.getPrivateKeyPassword(), (List)store.certificates());
        }
        CouchbaseProperties.Authentication.Jks jks = this.properties.getAuthentication().getJks();
        if (jks.getLocation() != null) {
            CertificateAuthenticator certificateAuthenticator;
            block11: {
                Resource resource = this.resourceLoader.getResource(jks.getLocation());
                String keystorePassword = jks.getPassword();
                InputStream inputStream = resource.getInputStream();
                try {
                    KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
                    store.load(inputStream, keystorePassword != null ? keystorePassword.toCharArray() : null);
                    certificateAuthenticator = CertificateAuthenticator.fromKeyStore((KeyStore)store, (String)keystorePassword);
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (GeneralSecurityException ex) {
                        throw new IllegalStateException("Error reading Couchbase certificate store", ex);
                    }
                }
                inputStream.close();
            }
            return certificateAuthenticator;
        }
        throw new IllegalStateException("Couchbase authentication requires username and password, or certificates");
    }

    @Bean(destroyMethod="disconnect")
    @ConditionalOnMissingBean
    public Cluster couchbaseCluster(ClusterEnvironment couchbaseClusterEnvironment, Authenticator authenticator, CouchbaseConnectionDetails connectionDetails) {
        ClusterOptions options = ClusterOptions.clusterOptions((Authenticator)authenticator).environment(couchbaseClusterEnvironment);
        return Cluster.connect((String)connectionDetails.getConnectionString(), (ClusterOptions)options);
    }

    private ClusterEnvironment.Builder initializeEnvironmentBuilder(SslBundles sslBundles) {
        ClusterEnvironment.Builder builder = ClusterEnvironment.builder();
        CouchbaseProperties.Timeouts timeouts = this.properties.getEnv().getTimeouts();
        builder.timeoutConfig(config -> config.kvTimeout(timeouts.getKeyValue()).analyticsTimeout(timeouts.getAnalytics()).kvDurableTimeout(timeouts.getKeyValueDurable()).queryTimeout(timeouts.getQuery()).viewTimeout(timeouts.getView()).searchTimeout(timeouts.getSearch()).managementTimeout(timeouts.getManagement()).connectTimeout(timeouts.getConnect()).disconnectTimeout(timeouts.getDisconnect()));
        CouchbaseProperties.Io io = this.properties.getEnv().getIo();
        builder.ioConfig(config -> config.maxHttpConnections(io.getMaxEndpoints()).numKvConnections(io.getMinEndpoints()).idleHttpConnectionTimeout(io.getIdleHttpConnectionTimeout()));
        if (this.properties.getEnv().getSsl().getEnabled().booleanValue()) {
            this.configureSsl(builder, sslBundles);
        }
        return builder;
    }

    private void configureSsl(ClusterEnvironment.Builder builder, SslBundles sslBundles) {
        CouchbaseProperties.Ssl sslProperties = this.properties.getEnv().getSsl();
        SslBundle sslBundle = StringUtils.hasText((String)sslProperties.getBundle()) ? sslBundles.getBundle(sslProperties.getBundle()) : null;
        Assert.state((sslBundle == null || !sslBundle.getOptions().isSpecified() ? 1 : 0) != 0, (String)"SSL Options cannot be specified with Couchbase");
        builder.securityConfig(config -> {
            config.enableTls(true);
            TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory(sslBundle);
            if (trustManagerFactory != null) {
                config.trustManagerFactory(trustManagerFactory);
            }
        });
    }

    private TrustManagerFactory getTrustManagerFactory(SslBundle sslBundle) {
        return sslBundle != null ? sslBundle.getManagers().getTrustManagerFactory() : null;
    }

    static final class PropertiesCouchbaseConnectionDetails
    implements CouchbaseConnectionDetails {
        private final CouchbaseProperties properties;

        PropertiesCouchbaseConnectionDetails(CouchbaseProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getConnectionString() {
            return this.properties.getConnectionString();
        }

        @Override
        public String getUsername() {
            return this.properties.getUsername();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }
    }

    static final class CouchbaseCondition
    extends AnyNestedCondition {
        CouchbaseCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={CouchbaseConnectionDetails.class})
        private static final class CouchbaseConnectionDetailsCondition {
            private CouchbaseConnectionDetailsCondition() {
            }
        }

        @ConditionalOnProperty(prefix="spring.couchbase", name={"connection-string"})
        private static final class CouchbaseUrlCondition {
            private CouchbaseUrlCondition() {
            }
        }
    }

    private static final class JacksonClusterEnvironmentBuilderCustomizer
    implements ClusterEnvironmentBuilderCustomizer,
    Ordered {
        private final ObjectMapper objectMapper;

        private JacksonClusterEnvironmentBuilderCustomizer(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Override
        public void customize(ClusterEnvironment.Builder builder) {
            builder.jsonSerializer((JsonSerializer)JacksonJsonSerializer.create((ObjectMapper)this.objectMapper));
        }

        public int getOrder() {
            return 0;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    static class JacksonConfiguration {
        JacksonConfiguration() {
        }

        @Bean
        @ConditionalOnSingleCandidate(value=ObjectMapper.class)
        ClusterEnvironmentBuilderCustomizer jacksonClusterEnvironmentBuilderCustomizer(ObjectMapper objectMapper) {
            return new JacksonClusterEnvironmentBuilderCustomizer(objectMapper.copy().registerModule((Module)new JsonValueModule()));
        }
    }
}

