/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.jackson.EndpointJsonMapper;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ClassUtils;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration
public final class JacksonEndpointAutoConfiguration {
    private static final String CONTRIBUTED_HEALTH = "org.springframework.boot.health.contributor.ContributedHealth";

    @Bean
    @ConditionalOnBooleanProperty(name={"management.endpoints.jackson.isolated-object-mapper"}, matchIfMissing=true)
    @ConditionalOnClass(value={ObjectMapper.class})
    EndpointJsonMapper endpointJsonMapper() {
        final JsonMapper jsonMapper = ((JsonMapper.Builder)JsonMapper.builder().changeDefaultPropertyInclusion(value -> value.withValueInclusion(JsonInclude.Include.NON_NULL).withContentInclusion(JsonInclude.Include.NON_NULL))).build();
        final HashSet<Class> supportedTypes = new HashSet<Class>(EndpointJsonMapper.DEFAULT_SUPPORTED_TYPES);
        if (ClassUtils.isPresent((String)CONTRIBUTED_HEALTH, null)) {
            supportedTypes.add(ClassUtils.resolveClassName((String)CONTRIBUTED_HEALTH, null));
        }
        return new EndpointJsonMapper(){
            final /* synthetic */ JacksonEndpointAutoConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            public JsonMapper get() {
                return jsonMapper;
            }

            public Set<Class<?>> getSupportedTypes() {
                return supportedTypes;
            }
        };
    }
}

